/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.ImageVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineImageViewer.TextWriterImageVisitor;

class DelimitedImageVisitor
extends TextWriterImageVisitor {
    private static final String defaultDelimiter = "\t";
    private final LinkedList<ImageVisitor.ImageElement> elemQ = new LinkedList();
    private long fileSize = 0L;
    private final Collection<ImageVisitor.ImageElement> elementsToTrack;
    private final AbstractMap<ImageVisitor.ImageElement, String> elements = new HashMap<ImageVisitor.ImageElement, String>();
    private final String delimiter;

    public DelimitedImageVisitor(String filename) throws IOException {
        this(filename, false);
    }

    public DelimitedImageVisitor(String outputFile, boolean printToScreen) throws IOException {
        this(outputFile, printToScreen, defaultDelimiter);
    }

    public DelimitedImageVisitor(String outputFile, boolean printToScreen, String delimiter) throws IOException {
        super(outputFile, printToScreen);
        this.elementsToTrack = new ArrayList<ImageVisitor.ImageElement>();
        Collections.addAll(this.elementsToTrack, ImageVisitor.ImageElement.INODE_PATH, ImageVisitor.ImageElement.REPLICATION, ImageVisitor.ImageElement.MODIFICATION_TIME, ImageVisitor.ImageElement.ACCESS_TIME, ImageVisitor.ImageElement.BLOCK_SIZE, ImageVisitor.ImageElement.NUM_BLOCKS, ImageVisitor.ImageElement.NUM_BYTES, ImageVisitor.ImageElement.NS_QUOTA, ImageVisitor.ImageElement.DS_QUOTA, ImageVisitor.ImageElement.PERMISSION_STRING, ImageVisitor.ImageElement.USER_NAME, ImageVisitor.ImageElement.GROUP_NAME);
        this.delimiter = delimiter;
        this.reset();
    }

    private void reset() {
        this.elements.clear();
        for (ImageVisitor.ImageElement e : this.elementsToTrack) {
            this.elements.put(e, null);
        }
        this.fileSize = 0L;
    }

    @Override
    void leaveEnclosingElement() throws IOException {
        ImageVisitor.ImageElement elem = this.elemQ.pop();
        if (elem == ImageVisitor.ImageElement.INODE || elem == ImageVisitor.ImageElement.INODE_UNDER_CONSTRUCTION) {
            this.writeLine();
            this.write("\n");
            this.reset();
        }
    }

    private void writeLine() throws IOException {
        Iterator<ImageVisitor.ImageElement> it = this.elementsToTrack.iterator();
        while (it.hasNext()) {
            ImageVisitor.ImageElement e = it.next();
            String v = null;
            v = e == ImageVisitor.ImageElement.NUM_BYTES ? String.valueOf(this.fileSize) : this.elements.get((Object)e);
            if (v != null) {
                this.write(v);
            }
            if (!it.hasNext()) continue;
            this.write(this.delimiter);
        }
    }

    @Override
    void visit(ImageVisitor.ImageElement element, String value) throws IOException {
        if (element == ImageVisitor.ImageElement.INODE_PATH && value.equals("")) {
            value = "/";
        }
        if (element == ImageVisitor.ImageElement.NUM_BYTES) {
            this.fileSize += Long.parseLong(value);
        }
        if (this.elements.containsKey((Object)element) && element != ImageVisitor.ImageElement.NUM_BYTES) {
            this.elements.put(element, value);
        }
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element) throws IOException {
        this.elemQ.push(element);
    }

    @Override
    void visitEnclosingElement(ImageVisitor.ImageElement element, ImageVisitor.ImageElement key, String value) throws IOException {
        if (key == ImageVisitor.ImageElement.NUM_BLOCKS && this.elements.containsKey((Object)ImageVisitor.ImageElement.NUM_BLOCKS)) {
            this.elements.put(key, value);
        }
        this.elemQ.push(element);
    }

    @Override
    void start() throws IOException {
    }
}

