/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirSnapshotOp;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.QuotaCounts;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ChunkedArrayList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;

class FSDirDeleteOp {
    FSDirDeleteOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long delete(FSDirectory fsd, INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) throws IOException {
        long filesRemoved;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.delete: " + iip.getPath());
        }
        fsd.writeLock();
        try {
            if (!FSDirDeleteOp.deleteAllowed(iip, iip.getPath())) {
                filesRemoved = -1L;
            } else {
                ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
                FSDirSnapshotOp.checkSnapshot(iip.getLastINode(), snapshottableDirs);
                filesRemoved = FSDirDeleteOp.unprotectedDelete(fsd, iip, collectedBlocks, removedINodes, mtime);
                fsd.getFSNamesystem().removeSnapshottableDirs(snapshottableDirs);
            }
        }
        finally {
            fsd.writeUnlock();
        }
        return filesRemoved;
    }

    static INode.BlocksMapUpdateInfo delete(FSNamesystem fsn, String src, boolean recursive, boolean logRetryCache) throws IOException {
        FSDirectory fsd = fsn.getFSDirectory();
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        INodesInPath iip = fsd.getINodesInPath4Write(src, false);
        if (!recursive && fsd.isNonEmptyDirectory(iip)) {
            throw new PathIsNotEmptyDirectoryException(src + " is non empty");
        }
        if (fsd.isPermissionEnabled()) {
            fsd.checkPermission(pc, iip, false, null, FsAction.WRITE, null, FsAction.ALL, true);
        }
        return FSDirDeleteOp.deleteInternal(fsn, src, iip, logRetryCache);
    }

    static void deleteForEditLog(FSDirectory fsd, String src, long mtime) throws IOException {
        assert (fsd.hasWriteLock());
        FSNamesystem fsn = fsd.getFSNamesystem();
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), false);
        if (!FSDirDeleteOp.deleteAllowed(iip, src)) {
            return;
        }
        ArrayList<INodeDirectory> snapshottableDirs = new ArrayList<INodeDirectory>();
        FSDirSnapshotOp.checkSnapshot(iip.getLastINode(), snapshottableDirs);
        long filesRemoved = FSDirDeleteOp.unprotectedDelete(fsd, iip, collectedBlocks, removedINodes, mtime);
        fsn.removeSnapshottableDirs(snapshottableDirs);
        if (filesRemoved >= 0L) {
            fsn.removeLeasesAndINodes(src, removedINodes, false);
            fsn.removeBlocksAndUpdateSafemodeTotal(collectedBlocks);
        }
    }

    static INode.BlocksMapUpdateInfo deleteInternal(FSNamesystem fsn, String src, INodesInPath iip, boolean logRetryCache) throws IOException {
        long mtime;
        ChunkedArrayList<INode> removedINodes;
        INode.BlocksMapUpdateInfo collectedBlocks;
        FSDirectory fsd;
        long filesRemoved;
        assert (fsn.hasWriteLock());
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.delete: " + src);
        }
        if ((filesRemoved = FSDirDeleteOp.delete(fsd = fsn.getFSDirectory(), iip, collectedBlocks = new INode.BlocksMapUpdateInfo(), removedINodes = new ChunkedArrayList<INode>(), mtime = Time.now())) < 0L) {
            return null;
        }
        fsd.getEditLog().logDelete(src, mtime, logRetryCache);
        FSDirDeleteOp.incrDeletedFileCount(filesRemoved);
        fsn.removeLeasesAndINodes(src, removedINodes, true);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* Namesystem.delete: " + src + " is removed");
        }
        return collectedBlocks;
    }

    static void incrDeletedFileCount(long count) {
        NameNode.getNameNodeMetrics().incrFilesDeleted(count);
    }

    private static boolean deleteAllowed(INodesInPath iip, String src) {
        if (iip.length() < 1 || iip.getLastINode() == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist");
            }
            return false;
        }
        if (iip.length() == 1) {
            NameNode.stateChangeLog.warn("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted");
            return false;
        }
        return true;
    }

    private static long unprotectedDelete(FSDirectory fsd, INodesInPath iip, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes, long mtime) {
        assert (fsd.hasWriteLock());
        INode targetNode = iip.getLastINode();
        if (targetNode == null) {
            return -1L;
        }
        int latestSnapshot = iip.getLatestSnapshotId();
        targetNode.recordModification(latestSnapshot);
        long removed = fsd.removeLastINode(iip);
        if (removed == -1L) {
            return -1L;
        }
        INodeDirectory parent = targetNode.getParent();
        parent.updateModificationTime(mtime, latestSnapshot);
        fsd.updateCountForDelete(targetNode, iip);
        if (removed == 0L) {
            return 0L;
        }
        if (!targetNode.isInLatestSnapshot(latestSnapshot)) {
            targetNode.destroyAndCollectBlocks(fsd.getBlockStoragePolicySuite(), collectedBlocks, removedINodes);
        } else {
            QuotaCounts counts = targetNode.cleanSubtree(fsd.getBlockStoragePolicySuite(), 0x7FFFFFFE, latestSnapshot, collectedBlocks, removedINodes);
            removed = counts.getNameSpace();
            fsd.updateCountNoQuotaCheck(iip, iip.length() - 1, counts.negation());
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* FSDirectory.unprotectedDelete: " + iip.getPath() + " is removed");
        }
        return removed;
    }
}

