/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality;

import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Murmur3Hash128;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.DenseHll;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.Format;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.HllInstance;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.SparseHll;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.Utils;

public class HyperLogLog {
    private static final int MAX_NUMBER_OF_BUCKETS = 65536;
    private HllInstance instance;

    private HyperLogLog(HllInstance instance) {
        this.instance = instance;
    }

    public static HyperLogLog newInstance(int numberOfBuckets) {
        Preconditions.checkArgument(numberOfBuckets <= 65536, "numberOfBuckets must be <= %s, actual: %s", 65536, numberOfBuckets);
        return new HyperLogLog(new SparseHll(Utils.indexBitLength(numberOfBuckets)));
    }

    public static HyperLogLog newInstance(Slice serialized) {
        Preconditions.checkArgument(serialized.getByte(0) != Format.SPARSE_V1.getTag(), "Sparse v1 encoding no longer supported");
        if (SparseHll.canDeserialize(serialized)) {
            return new HyperLogLog(new SparseHll(serialized));
        }
        if (DenseHll.canDeserialize(serialized)) {
            return new HyperLogLog(new DenseHll(serialized));
        }
        throw new IllegalArgumentException("Cannot deserialize HyperLogLog");
    }

    public void add(long value) {
        this.addHash(Murmur3Hash128.hash64(value));
    }

    public void add(Slice value) {
        this.addHash(Murmur3Hash128.hash64(value));
    }

    public void addHash(long hash) {
        this.instance.insertHash(hash);
        if (this.instance instanceof SparseHll) {
            this.instance = HyperLogLog.makeDenseIfNecessary((SparseHll)this.instance);
        }
    }

    public void mergeWith(HyperLogLog other) {
        if (this.instance instanceof SparseHll && other.instance instanceof SparseHll) {
            ((SparseHll)this.instance).mergeWith((SparseHll)other.instance);
            this.instance = HyperLogLog.makeDenseIfNecessary((SparseHll)this.instance);
        } else {
            DenseHll dense = this.instance.toDense();
            dense.mergeWith(other.instance.toDense());
            this.instance = dense;
        }
    }

    public long cardinality() {
        return this.instance.cardinality();
    }

    public int estimatedInMemorySize() {
        return this.instance.estimatedInMemorySize();
    }

    public int estimatedSerializedSize() {
        return this.instance.estimatedSerializedSize();
    }

    public Slice serialize() {
        return this.instance.serialize();
    }

    public void makeDense() {
        this.instance = this.instance.toDense();
    }

    @VisibleForTesting
    void verify() {
        this.instance.verify();
    }

    private static HllInstance makeDenseIfNecessary(SparseHll instance) {
        if (instance.estimatedInMemorySize() > DenseHll.estimatedInMemorySize(instance.getIndexBitLength())) {
            return instance.toDense();
        }
        return instance;
    }
}

