/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForCachingHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.BridgingHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.CachingHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ThriftHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Scopes;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.ObjectNames;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.guice.ExportBinder;

public class ThriftMetastoreModule
implements Module {
    private final String connectorId;

    public ThriftMetastoreModule(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public void configure(Binder binder) {
        binder.bind(HiveMetastore.class).to(ThriftHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(ExtendedHiveMetastore.class).annotatedWith(ForCachingHiveMetastore.class).to(BridgingHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(ExtendedHiveMetastore.class).to(CachingHiveMetastore.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter(binder).export(HiveMetastore.class).as(ObjectNames.generatedNameOf(ThriftHiveMetastore.class, this.connectorId));
        ExportBinder.newExporter(binder).export(ExtendedHiveMetastore.class).as(ObjectNames.generatedNameOf(CachingHiveMetastore.class, this.connectorId));
    }
}

