/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.NetgroupCache;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class JniBasedUnixGroupsNetgroupMapping
extends JniBasedUnixGroupsMapping {
    private static final Log LOG = LogFactory.getLog(JniBasedUnixGroupsNetgroupMapping.class);

    native String[] getUsersForNetgroupJNI(String var1);

    @Override
    public List<String> getGroups(String user) throws IOException {
        LinkedList<String> groups = new LinkedList<String>(super.getGroups(user));
        NetgroupCache.getNetgroups(user, groups);
        return groups;
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        List<String> groups = NetgroupCache.getNetgroupNames();
        NetgroupCache.clear();
        this.cacheGroupsAdd(groups);
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        for (String group : groups) {
            if (group.length() == 0 || group.charAt(0) != '@' || NetgroupCache.isCached(group)) continue;
            NetgroupCache.add(group, this.getUsersForNetgroup(group));
        }
    }

    protected synchronized List<String> getUsersForNetgroup(String netgroup) {
        String[] users = null;
        try {
            users = this.getUsersForNetgroupJNI(netgroup.substring(1));
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error getting users for netgroup " + netgroup, e);
            }
            LOG.info("Error getting users for netgroup " + netgroup + ": " + e.getMessage());
        }
        if (users != null && users.length != 0) {
            return Arrays.asList(users);
        }
        return new LinkedList<String>();
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            throw new RuntimeException("Bailing out since native library couldn't be loaded");
        }
        LOG.debug("Using JniBasedUnixGroupsNetgroupMapping for Netgroup resolution");
    }
}

