/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.FileSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.RecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Reporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.SequenceFileRecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFilter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileInputFilter<K, V>
extends SequenceFileInputFormat<K, V> {
    private static final String FILTER_CLASS = "mapreduce.input.sequencefileinputfilter.class";

    @Override
    public RecordReader<K, V> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new FilterRecordReader(job, (FileSplit)split);
    }

    public static void setFilterClass(Configuration conf, Class filterClass) {
        conf.set(FILTER_CLASS, filterClass.getName());
    }

    private static class FilterRecordReader<K, V>
    extends SequenceFileRecordReader<K, V> {
        private Filter filter;

        public FilterRecordReader(Configuration conf, FileSplit split) throws IOException {
            super(conf, split);
            this.filter = (Filter)ReflectionUtils.newInstance(conf.getClass(SequenceFileInputFilter.FILTER_CLASS, PercentFilter.class), conf);
        }

        @Override
        public synchronized boolean next(K key, V value) throws IOException {
            while (this.next(key)) {
                if (!this.filter.accept(key)) continue;
                this.getCurrentValue(value);
                return true;
            }
            return false;
        }
    }

    public static class MD5Filter
    extends FilterBase {
        public static final int MD5_LEN = 16;
        SequenceFileInputFilter.MD5Filter mf = new SequenceFileInputFilter.MD5Filter();

        public static void setFrequency(Configuration conf, int frequency) {
            SequenceFileInputFilter.MD5Filter.setFrequency(conf, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.mf.setConf(conf);
        }

        @Override
        public boolean accept(Object key) {
            return this.mf.accept(key);
        }
    }

    public static class PercentFilter
    extends FilterBase {
        SequenceFileInputFilter.PercentFilter pf = new SequenceFileInputFilter.PercentFilter();

        public static void setFrequency(Configuration conf, int frequency) {
            SequenceFileInputFilter.PercentFilter.setFrequency(conf, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.pf.setConf(conf);
        }

        @Override
        public boolean accept(Object key) {
            return this.pf.accept(key);
        }
    }

    public static class RegexFilter
    extends FilterBase {
        SequenceFileInputFilter.RegexFilter rf = new SequenceFileInputFilter.RegexFilter();

        public static void setPattern(Configuration conf, String regex) throws PatternSyntaxException {
            SequenceFileInputFilter.RegexFilter.setPattern(conf, regex);
        }

        @Override
        public void setConf(Configuration conf) {
            this.rf.setConf(conf);
        }

        @Override
        public boolean accept(Object key) {
            return this.rf.accept(key);
        }
    }

    public static abstract class FilterBase
    extends SequenceFileInputFilter.FilterBase
    implements Filter {
    }

    public static interface Filter
    extends SequenceFileInputFilter.Filter {
    }
}

