/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public enum Op {
    WRITE_BLOCK(80),
    READ_BLOCK(81),
    READ_METADATA(82),
    REPLACE_BLOCK(83),
    COPY_BLOCK(84),
    BLOCK_CHECKSUM(85),
    TRANSFER_BLOCK(86),
    REQUEST_SHORT_CIRCUIT_FDS(87),
    RELEASE_SHORT_CIRCUIT_FDS(88),
    REQUEST_SHORT_CIRCUIT_SHM(89);

    public final byte code;
    private static final int FIRST_CODE;

    private Op(byte code) {
        this.code = code;
    }

    private static Op valueOf(byte code) {
        int i = (code & 0xFF) - FIRST_CODE;
        return i < 0 || i >= Op.values().length ? null : Op.values()[i];
    }

    public static Op read(DataInput in) throws IOException {
        return Op.valueOf(in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.code);
    }

    static {
        FIRST_CODE = Op.values()[0].code;
    }
}

