/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.regions;

import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.regions.Region;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.regions.RegionUtils;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.EC2MetadataUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.commons.logging.LogFactory;

public enum Regions {
    GovCloud("us-gov-west-1"),
    US_EAST_1("us-east-1"),
    US_EAST_2("us-east-2"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    EU_WEST_1("eu-west-1"),
    EU_WEST_2("eu-west-2"),
    EU_CENTRAL_1("eu-central-1"),
    AP_SOUTH_1("ap-south-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    AP_NORTHEAST_2("ap-northeast-2"),
    SA_EAST_1("sa-east-1"),
    CN_NORTH_1("cn-north-1"),
    CA_CENTRAL_1("ca-central-1");

    public static final Regions DEFAULT_REGION;
    private final String name;

    private Regions(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Regions fromName(String regionName) {
        for (Regions region : Regions.values()) {
            if (!region.getName().equals(regionName)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + regionName + " value!");
    }

    public static Region getCurrentRegion() {
        try {
            String region = EC2MetadataUtils.getEC2InstanceRegion();
            if (region != null) {
                return RegionUtils.getRegion(region);
            }
        }
        catch (AmazonClientException e) {
            LogFactory.getLog(Regions.class).debug("Ignoring failure to retrieve the region: " + e.getMessage());
        }
        return null;
    }

    static {
        DEFAULT_REGION = US_WEST_2;
    }
}

