/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.StringUtils;

public class S3PrestoFileSystem
extends HadoopFileSystem
implements EntropyInjectingFileSystem {
    @Nullable
    private final String entropyInjectionKey;
    private final int entropyLength;

    public S3PrestoFileSystem(PrestoS3FileSystem prestoFs) {
        this(prestoFs, null, -1);
    }

    public S3PrestoFileSystem(PrestoS3FileSystem prestoFs, @Nullable String entropyInjectionKey, int entropyLength) {
        super(prestoFs);
        if (entropyInjectionKey != null && entropyLength <= 0) {
            throw new IllegalArgumentException("Entropy length must be >= 0 when entropy injection key is set");
        }
        this.entropyInjectionKey = entropyInjectionKey;
        this.entropyLength = entropyLength;
    }

    @Nullable
    public String getEntropyInjectionKey() {
        return this.entropyInjectionKey;
    }

    public String generateEntropy() {
        return StringUtils.generateRandomAlphanumericString((Random)ThreadLocalRandom.current(), (int)this.entropyLength);
    }

    @Override
    public FileSystemKind getKind() {
        return FileSystemKind.OBJECT_STORE;
    }
}

