/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.UTF8;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ArrayPrimitiveWritable
implements Writable {
    private Class<?> componentType = null;
    private Class<?> declaredComponentType = null;
    private int length;
    private Object value;
    private static final Map<String, Class<?>> PRIMITIVE_NAMES = new HashMap(16);

    private static Class<?> getPrimitiveClass(String className) {
        return PRIMITIVE_NAMES.get(className);
    }

    private static void checkPrimitive(Class<?> componentType) {
        if (componentType == null) {
            throw new HadoopIllegalArgumentException("null component type not allowed");
        }
        if (!PRIMITIVE_NAMES.containsKey(componentType.getName())) {
            throw new HadoopIllegalArgumentException("input array component type " + componentType.getName() + " is not a candidate primitive type");
        }
    }

    private void checkDeclaredComponentType(Class<?> componentType) {
        if (this.declaredComponentType != null && componentType != this.declaredComponentType) {
            throw new HadoopIllegalArgumentException("input array component type " + componentType.getName() + " does not match declared type " + this.declaredComponentType.getName());
        }
    }

    private static void checkArray(Object value) {
        if (value == null) {
            throw new HadoopIllegalArgumentException("null value not allowed");
        }
        if (!value.getClass().isArray()) {
            throw new HadoopIllegalArgumentException("non-array value of class " + value.getClass() + " not allowed");
        }
    }

    public ArrayPrimitiveWritable() {
    }

    public ArrayPrimitiveWritable(Class<?> componentType) {
        ArrayPrimitiveWritable.checkPrimitive(componentType);
        this.declaredComponentType = componentType;
    }

    public ArrayPrimitiveWritable(Object value) {
        this.set(value);
    }

    public Object get() {
        return this.value;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public Class<?> getDeclaredComponentType() {
        return this.declaredComponentType;
    }

    public boolean isDeclaredComponentType(Class<?> componentType) {
        return componentType == this.declaredComponentType;
    }

    public void set(Object value) {
        ArrayPrimitiveWritable.checkArray(value);
        Class<?> componentType = value.getClass().getComponentType();
        ArrayPrimitiveWritable.checkPrimitive(componentType);
        this.checkDeclaredComponentType(componentType);
        this.componentType = componentType;
        this.value = value;
        this.length = Array.getLength(value);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.componentType.getName());
        out.writeInt(this.length);
        if (this.componentType == Boolean.TYPE) {
            this.writeBooleanArray(out);
        } else if (this.componentType == Character.TYPE) {
            this.writeCharArray(out);
        } else if (this.componentType == Byte.TYPE) {
            this.writeByteArray(out);
        } else if (this.componentType == Short.TYPE) {
            this.writeShortArray(out);
        } else if (this.componentType == Integer.TYPE) {
            this.writeIntArray(out);
        } else if (this.componentType == Long.TYPE) {
            this.writeLongArray(out);
        } else if (this.componentType == Float.TYPE) {
            this.writeFloatArray(out);
        } else if (this.componentType == Double.TYPE) {
            this.writeDoubleArray(out);
        } else {
            throw new IOException("Component type " + this.componentType.toString() + " is set as the output type, but no encoding is implemented for this type.");
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String className = UTF8.readString(in);
        Class<?> componentType = ArrayPrimitiveWritable.getPrimitiveClass(className);
        if (componentType == null) {
            throw new IOException("encoded array component type " + className + " is not a candidate primitive type");
        }
        this.checkDeclaredComponentType(componentType);
        this.componentType = componentType;
        int length = in.readInt();
        if (length < 0) {
            throw new IOException("encoded array length is negative " + length);
        }
        this.length = length;
        this.value = Array.newInstance(componentType, length);
        if (componentType == Boolean.TYPE) {
            this.readBooleanArray(in);
        } else if (componentType == Character.TYPE) {
            this.readCharArray(in);
        } else if (componentType == Byte.TYPE) {
            this.readByteArray(in);
        } else if (componentType == Short.TYPE) {
            this.readShortArray(in);
        } else if (componentType == Integer.TYPE) {
            this.readIntArray(in);
        } else if (componentType == Long.TYPE) {
            this.readLongArray(in);
        } else if (componentType == Float.TYPE) {
            this.readFloatArray(in);
        } else if (componentType == Double.TYPE) {
            this.readDoubleArray(in);
        } else {
            throw new IOException("Encoded type " + className + " converted to valid component type " + componentType.toString() + " but no encoding is implemented for this type.");
        }
    }

    private void writeBooleanArray(DataOutput out) throws IOException {
        boolean[] v = (boolean[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeBoolean(v[i]);
        }
    }

    private void writeCharArray(DataOutput out) throws IOException {
        char[] v = (char[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeChar(v[i]);
        }
    }

    private void writeByteArray(DataOutput out) throws IOException {
        out.write((byte[])this.value, 0, this.length);
    }

    private void writeShortArray(DataOutput out) throws IOException {
        short[] v = (short[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeShort(v[i]);
        }
    }

    private void writeIntArray(DataOutput out) throws IOException {
        int[] v = (int[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeInt(v[i]);
        }
    }

    private void writeLongArray(DataOutput out) throws IOException {
        long[] v = (long[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeLong(v[i]);
        }
    }

    private void writeFloatArray(DataOutput out) throws IOException {
        float[] v = (float[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeFloat(v[i]);
        }
    }

    private void writeDoubleArray(DataOutput out) throws IOException {
        double[] v = (double[])this.value;
        for (int i = 0; i < this.length; ++i) {
            out.writeDouble(v[i]);
        }
    }

    private void readBooleanArray(DataInput in) throws IOException {
        boolean[] v = (boolean[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readBoolean();
        }
    }

    private void readCharArray(DataInput in) throws IOException {
        char[] v = (char[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readChar();
        }
    }

    private void readByteArray(DataInput in) throws IOException {
        in.readFully((byte[])this.value, 0, this.length);
    }

    private void readShortArray(DataInput in) throws IOException {
        short[] v = (short[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readShort();
        }
    }

    private void readIntArray(DataInput in) throws IOException {
        int[] v = (int[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readInt();
        }
    }

    private void readLongArray(DataInput in) throws IOException {
        long[] v = (long[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readLong();
        }
    }

    private void readFloatArray(DataInput in) throws IOException {
        float[] v = (float[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readFloat();
        }
    }

    private void readDoubleArray(DataInput in) throws IOException {
        double[] v = (double[])this.value;
        for (int i = 0; i < this.length; ++i) {
            v[i] = in.readDouble();
        }
    }

    static {
        PRIMITIVE_NAMES.put(Boolean.TYPE.getName(), Boolean.TYPE);
        PRIMITIVE_NAMES.put(Byte.TYPE.getName(), Byte.TYPE);
        PRIMITIVE_NAMES.put(Character.TYPE.getName(), Character.TYPE);
        PRIMITIVE_NAMES.put(Short.TYPE.getName(), Short.TYPE);
        PRIMITIVE_NAMES.put(Integer.TYPE.getName(), Integer.TYPE);
        PRIMITIVE_NAMES.put(Long.TYPE.getName(), Long.TYPE);
        PRIMITIVE_NAMES.put(Float.TYPE.getName(), Float.TYPE);
        PRIMITIVE_NAMES.put(Double.TYPE.getName(), Double.TYPE);
    }

    static class Internal
    extends ArrayPrimitiveWritable {
        Internal() {
        }

        Internal(Object value) {
            super(value);
        }
    }
}

