/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.net.Peer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.unix.DomainSocket;

@InterfaceAudience.Private
public class DomainPeer
implements Peer {
    private final DomainSocket socket;
    private final OutputStream out;
    private final InputStream in;
    private final ReadableByteChannel channel;

    public DomainPeer(DomainSocket socket) {
        this.socket = socket;
        this.out = socket.getOutputStream();
        this.in = socket.getInputStream();
        this.channel = socket.getChannel();
    }

    @Override
    public ReadableByteChannel getInputStreamChannel() {
        return this.channel;
    }

    @Override
    public void setReadTimeout(int timeoutMs) throws IOException {
        this.socket.setAttribute(4, timeoutMs);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.socket.getAttribute(2);
    }

    @Override
    public boolean getTcpNoDelay() throws IOException {
        return false;
    }

    @Override
    public void setWriteTimeout(int timeoutMs) throws IOException {
        this.socket.setAttribute(3, timeoutMs);
    }

    @Override
    public boolean isClosed() {
        return !this.socket.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public String getRemoteAddressString() {
        return "unix:" + this.socket.getPath();
    }

    @Override
    public String getLocalAddressString() {
        return "<local>";
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return "DomainPeer(" + this.getRemoteAddressString() + ")";
    }

    @Override
    public DomainSocket getDomainSocket() {
        return this.socket;
    }

    @Override
    public boolean hasSecureChannel() {
        return true;
    }
}

