/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.BlockReader;

class BlockReaderUtil {
    BlockReaderUtil() {
    }

    public static int readAll(BlockReader reader, byte[] buf, int offset, int len) throws IOException {
        int nread;
        int n = 0;
        do {
            if ((nread = reader.read(buf, offset + n, len - n)) > 0) continue;
            return n == 0 ? nread : n;
        } while ((n += nread) < len);
        return n;
    }

    public static void readFully(BlockReader reader, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = reader.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }
}

