/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPage;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetEncoding;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import parquet.column.statistics.Statistics;

public class ParquetDataPageV2
extends ParquetDataPage {
    private final int rowCount;
    private final int nullCount;
    private final Slice repetitionLevels;
    private final Slice definitionLevels;
    private final ParquetEncoding dataEncoding;
    private final Slice slice;
    private final Statistics<?> statistics;
    private final boolean isCompressed;

    public ParquetDataPageV2(int rowCount, int nullCount, int valueCount, Slice repetitionLevels, Slice definitionLevels, ParquetEncoding dataEncoding, Slice slice, int uncompressedSize, Statistics<?> statistics, boolean isCompressed) {
        super(repetitionLevels.length() + definitionLevels.length() + slice.length(), uncompressedSize, valueCount);
        this.rowCount = rowCount;
        this.nullCount = nullCount;
        this.repetitionLevels = Objects.requireNonNull(repetitionLevels, "repetitionLevels slice is null");
        this.definitionLevels = Objects.requireNonNull(definitionLevels, "definitionLevels slice is null");
        this.dataEncoding = dataEncoding;
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.statistics = statistics;
        this.isCompressed = isCompressed;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getNullCount() {
        return this.nullCount;
    }

    public Slice getRepetitionLevels() {
        return this.repetitionLevels;
    }

    public Slice getDefinitionLevels() {
        return this.definitionLevels;
    }

    public ParquetEncoding getDataEncoding() {
        return this.dataEncoding;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rowCount", this.rowCount).add("nullCount", this.nullCount).add("repetitionLevels", this.repetitionLevels).add("definitionLevels", this.definitionLevels).add("dataEncoding", (Object)this.dataEncoding).add("slice", this.slice).add("statistics", this.statistics).add("isCompressed", this.isCompressed).add("valueCount", this.valueCount).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

