/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.http;

import java.util.Arrays;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.HttpResponse;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.http.ErrorCodeParser;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.protocol.json.JsonContent;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    public CompositeErrorCodeParser(Iterable<ErrorCodeParser> parsers) {
        this.parsers = parsers;
    }

    public CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

