/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.s3presto.S3PrestoFileSystem;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopConfigLoader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemFactory
implements FileSystemFactory {
    public static final ConfigOption<String> ENTROPY_INJECT_KEY_OPTION = ConfigOptions.key((String)"s3.entropy.key").noDefaultValue().withDescription("This option can be used to improve performance due to sharding issues on Amazon S3. For file creations with entropy injection, this key will be replaced by random alphanumeric characters. For other file creations, the key will be filtered out.");
    public static final ConfigOption<Integer> ENTROPY_INJECT_LENGTH_OPTION = ConfigOptions.key((String)"s3.entropy.length").defaultValue((Object)4).withDescription("When '" + ENTROPY_INJECT_KEY_OPTION.key() + "' is set, this option defines the number of random characters to replace the entropy key with.");
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemFactory.class);
    private static final String INVALID_ENTROPY_KEY_CHARS = "^.*[~#@*+%{}<>\\[\\]|\"\\\\].*$";
    private static final Set<String> PACKAGE_PREFIXES_TO_SHADE = new HashSet<String>(Collections.singletonList("org.apache.flink.fs.s3presto.shaded.com.amazonaws."));
    private static final Set<String> CONFIG_KEYS_TO_SHADE = Collections.unmodifiableSet(new HashSet<String>(Collections.singleton("presto.s3.credentials-provider")));
    private static final String FLINK_SHADING_PREFIX = "org.apache.flink.fs.s3presto.shaded.";
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"s3.", "presto.s3."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"presto.s3.access.key", "presto.s3.access-key"}, {"presto.s3.secret.key", "presto.s3.secret-key"}};
    private final HadoopConfigLoader hadoopConfigLoader = S3FileSystemFactory.createHadoopConfigLoader();
    private org.apache.flink.configuration.Configuration flinkConfig;

    public String getScheme() {
        return "s3";
    }

    public void configure(org.apache.flink.configuration.Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfigLoader.setFlinkConfig(config);
    }

    public FileSystem create(URI fsUri) throws IOException {
        org.apache.flink.configuration.Configuration flinkConfig = this.flinkConfig;
        if (flinkConfig == null) {
            LOG.warn("Creating S3 Presto FileSystem without configuring the factory. All behavior will be default.");
            flinkConfig = new org.apache.flink.configuration.Configuration();
        }
        LOG.debug("Creating S3 file system backed by PrestoS3FileSystem");
        try {
            Configuration hadoopConfig = this.hadoopConfigLoader.getOrLoadHadoopConfig();
            PrestoS3FileSystem fs = new PrestoS3FileSystem();
            fs.initialize(S3FileSystemFactory.createInitUri(fsUri), hadoopConfig);
            String entropyInjectionKey = flinkConfig.getString(ENTROPY_INJECT_KEY_OPTION);
            int numEntropyChars = -1;
            if (entropyInjectionKey != null) {
                if (entropyInjectionKey.matches(INVALID_ENTROPY_KEY_CHARS)) {
                    throw new IllegalConfigurationException("Invalid character in value for " + ENTROPY_INJECT_KEY_OPTION.key() + " : " + entropyInjectionKey);
                }
                numEntropyChars = flinkConfig.getInteger(ENTROPY_INJECT_LENGTH_OPTION);
                if (numEntropyChars <= 0) {
                    throw new IllegalConfigurationException(ENTROPY_INJECT_LENGTH_OPTION.key() + " must configure a value > 0");
                }
            }
            return new S3PrestoFileSystem(fs, entropyInjectionKey, numEntropyChars);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    static HadoopConfigLoader createHadoopConfigLoader() {
        return new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, "presto.s3.", PACKAGE_PREFIXES_TO_SHADE, CONFIG_KEYS_TO_SHADE, FLINK_SHADING_PREFIX);
    }

    private static URI createInitUri(URI fsUri) {
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        URI initUri = scheme == null && authority == null ? S3FileSystemFactory.createURI("s3://s3.amazonaws.com") : (scheme != null && authority == null ? S3FileSystemFactory.createURI(scheme + "://s3.amazonaws.com") : fsUri);
        return initUri;
    }

    private static URI createURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new FlinkRuntimeException("Error in s3 aws URI - " + str, (Throwable)e);
        }
    }
}

