/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.web.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.web.resources.EnumParam;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.web.resources.PutOpParam;

public abstract class HttpOpParam<E extends Enum<E>>
extends EnumParam<E> {
    public static final String NAME = "op";
    public static final String DEFAULT = "null";

    @Override
    public String getValueString() {
        return ((Enum)this.value).toString();
    }

    HttpOpParam(EnumParam.Domain<E> domain, E value) {
        super(domain, value);
    }

    public static class TemporaryRedirectOp
    implements Op {
        static final TemporaryRedirectOp CREATE = new TemporaryRedirectOp(PutOpParam.Op.CREATE);
        static final TemporaryRedirectOp APPEND = new TemporaryRedirectOp(PostOpParam.Op.APPEND);
        static final TemporaryRedirectOp OPEN = new TemporaryRedirectOp(GetOpParam.Op.OPEN);
        static final TemporaryRedirectOp GETFILECHECKSUM = new TemporaryRedirectOp(GetOpParam.Op.GETFILECHECKSUM);
        static final List<TemporaryRedirectOp> values = Collections.unmodifiableList(Arrays.asList(CREATE, APPEND, OPEN, GETFILECHECKSUM));
        private final Op op;

        public static TemporaryRedirectOp valueOf(Op op) {
            for (TemporaryRedirectOp t : values) {
                if (op != t.op) continue;
                return t;
            }
            throw new IllegalArgumentException(op + " not found.");
        }

        private TemporaryRedirectOp(Op op) {
            this.op = op;
        }

        @Override
        public Type getType() {
            return this.op.getType();
        }

        @Override
        public boolean getRequireAuth() {
            return this.op.getRequireAuth();
        }

        @Override
        public boolean getDoOutput() {
            return false;
        }

        @Override
        public boolean getRedirect() {
            return false;
        }

        @Override
        public int getExpectedHttpResponseCode() {
            return Response.Status.TEMPORARY_REDIRECT.getStatusCode();
        }

        @Override
        public String toQueryString() {
            return this.op.toQueryString();
        }
    }

    public static interface Op {
        public Type getType();

        public boolean getRequireAuth();

        public boolean getDoOutput();

        public boolean getRedirect();

        public int getExpectedHttpResponseCode();

        public String toQueryString();
    }

    public static enum Type {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

