/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.BinaryEditsVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.StatisticsEditsVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.TeeOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.tools.offlineEditsViewer.XmlEditsVisitor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsVisitorFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfflineEditsVisitor getEditsVisitor(String filename, String processor, boolean printToScreen) throws IOException {
        if (StringUtils.equalsIgnoreCase("binary", processor)) {
            return new BinaryEditsVisitor(filename);
        }
        FileOutputStream fout = new FileOutputStream(filename);
        OutputStream out = null;
        try {
            OfflineEditsVisitor vis;
            if (!printToScreen) {
                out = fout;
            } else {
                OutputStream[] outs = new OutputStream[]{fout, System.out};
                out = new TeeOutputStream(outs);
            }
            if (StringUtils.equalsIgnoreCase("xml", processor)) {
                vis = new XmlEditsVisitor(out);
            } else if (StringUtils.equalsIgnoreCase("stats", processor)) {
                vis = new StatisticsEditsVisitor(out);
            } else {
                throw new IOException("Unknown proccesor " + processor + " (valid processors: xml, binary, stats)");
            }
            fout = null;
            out = null;
            OfflineEditsVisitor offlineEditsVisitor = vis;
            return offlineEditsVisitor;
        }
        finally {
            IOUtils.closeStream(fout);
            IOUtils.closeStream(out);
        }
    }
}

