/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util.EnumCounters;

public class ContentCounts {
    private EnumCounters<Content> contents;
    private EnumCounters<StorageType> types;

    private ContentCounts(EnumCounters<Content> contents, EnumCounters<StorageType> types) {
        this.contents = contents;
        this.types = types;
    }

    public long getFileCount() {
        return this.contents.get(Content.FILE);
    }

    public long getDirectoryCount() {
        return this.contents.get(Content.DIRECTORY);
    }

    public long getSymlinkCount() {
        return this.contents.get(Content.SYMLINK);
    }

    public long getLength() {
        return this.contents.get(Content.LENGTH);
    }

    public long getStoragespace() {
        return this.contents.get(Content.DISKSPACE);
    }

    public long getSnapshotCount() {
        return this.contents.get(Content.SNAPSHOT);
    }

    public long getSnapshotableDirectoryCount() {
        return this.contents.get(Content.SNAPSHOTTABLE_DIRECTORY);
    }

    public long[] getTypeSpaces() {
        return this.types.asArray();
    }

    public long getTypeSpace(StorageType t) {
        return this.types.get(t);
    }

    public void addContent(Content c, long val) {
        this.contents.add(c, val);
    }

    public void addContents(ContentCounts that) {
        this.contents.add(that.contents);
        this.types.add(that.types);
    }

    public void addTypeSpace(StorageType t, long val) {
        this.types.add(t, val);
    }

    public void addTypeSpaces(EnumCounters<StorageType> that) {
        this.types.add(that);
    }

    public static class Builder {
        private EnumCounters<Content> contents = new EnumCounters<Content>(Content.class);
        private EnumCounters<StorageType> types = new EnumCounters<StorageType>(StorageType.class);

        public Builder file(long file) {
            this.contents.set(Content.FILE, file);
            return this;
        }

        public Builder directory(long directory) {
            this.contents.set(Content.DIRECTORY, directory);
            return this;
        }

        public Builder symlink(long symlink) {
            this.contents.set(Content.SYMLINK, symlink);
            return this;
        }

        public Builder length(long length) {
            this.contents.set(Content.LENGTH, length);
            return this;
        }

        public Builder storagespace(long storagespace) {
            this.contents.set(Content.DISKSPACE, storagespace);
            return this;
        }

        public Builder snapshot(long snapshot) {
            this.contents.set(Content.SNAPSHOT, snapshot);
            return this;
        }

        public Builder snapshotable_directory(long snapshotable_directory) {
            this.contents.set(Content.SNAPSHOTTABLE_DIRECTORY, snapshotable_directory);
            return this;
        }

        public ContentCounts build() {
            return new ContentCounts(this.contents, this.types);
        }
    }
}

