/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.web;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.bootstrap.ChannelFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.bootstrap.ServerBootstrap;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.ChannelFuture;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.ChannelInitializer;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.ChannelPipeline;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.EventLoopGroup;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.socket.SocketChannel;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.ssl.SslHandler;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.web.URLDispatcher;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FileChecksumServlets;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.StreamFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.http.HttpConfig;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.http.HttpServer2;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.NetUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.ssl.SSLFactory;

public class DatanodeHttpServer
implements Closeable {
    private final HttpServer2 infoServer;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final ServerSocketChannel externalHttpChannel;
    private final ServerBootstrap httpServer;
    private final SSLFactory sslFactory;
    private final ServerBootstrap httpsServer;
    private final Configuration conf;
    private final Configuration confForCreate;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;
    static final Log LOG = LogFactory.getLog(DatanodeHttpServer.class);

    public DatanodeHttpServer(final Configuration conf, DataNode datanode, final ServerSocketChannel externalHttpChannel) throws IOException {
        this.conf = conf;
        Configuration confForInfoServer = new Configuration(conf);
        confForInfoServer.setInt("hadoop.http.max.threads", 10);
        HttpServer2.Builder builder = new HttpServer2.Builder().setName("datanode").setConf(confForInfoServer).setACL(new AccessControlList(conf.get("dfs.cluster.administrators", " "))).hostName(DatanodeHttpServer.getHostnameForSpnegoPrincipal(confForInfoServer)).addEndpoint(URI.create("http://localhost:0")).setFindPort(true);
        this.infoServer = builder.build();
        this.infoServer.addInternalServlet(null, "/streamFile/*", StreamFile.class);
        this.infoServer.addInternalServlet(null, "/getFileChecksum/*", FileChecksumServlets.GetServlet.class);
        this.infoServer.setAttribute("datanode", datanode);
        this.infoServer.setAttribute("current.conf", conf);
        this.infoServer.addServlet(null, "/blockScannerReport", BlockScanner.Servlet.class);
        this.infoServer.start();
        final InetSocketAddress jettyAddr = this.infoServer.getConnectorAddress(0);
        this.confForCreate = new Configuration(conf);
        this.confForCreate.set("fs.permissions.umask-mode", "000");
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.externalHttpChannel = externalHttpChannel;
        HttpConfig.Policy policy = DFSUtil.getHttpPolicy(conf);
        if (policy.isHttpEnabled()) {
            this.httpServer = new ServerBootstrap().group(this.bossGroup, this.workerGroup).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new HttpRequestDecoder(), new HttpResponseEncoder(), new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate));
                }
            });
            if (externalHttpChannel == null) {
                this.httpServer.channel(NioServerSocketChannel.class);
            } else {
                this.httpServer.channelFactory(new ChannelFactory<NioServerSocketChannel>(){

                    @Override
                    public NioServerSocketChannel newChannel() {
                        return new NioServerSocketChannel(externalHttpChannel){

                            @Override
                            protected void doBind(SocketAddress localAddress) throws Exception {
                            }
                        };
                    }
                });
            }
        } else {
            this.httpServer = null;
        }
        if (policy.isHttpsEnabled()) {
            this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
            try {
                this.sslFactory.init();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            this.httpsServer = ((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new SslHandler(DatanodeHttpServer.this.sslFactory.createSSLEngine()), new HttpRequestDecoder(), new HttpResponseEncoder(), new ChunkedWriteHandler(), new URLDispatcher(jettyAddr, conf, DatanodeHttpServer.this.confForCreate));
                }
            });
        } else {
            this.httpsServer = null;
            this.sslFactory = null;
        }
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    public void start() {
        if (this.httpServer != null) {
            ChannelFuture f = this.httpServer.bind(DataNode.getInfoAddr(this.conf));
            f.syncUninterruptibly();
            this.httpAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info("Listening HTTP traffic on " + this.httpAddress);
        }
        if (this.httpsServer != null) {
            InetSocketAddress secInfoSocAddr = NetUtils.createSocketAddr(this.conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:50475"));
            ChannelFuture f = this.httpsServer.bind(secInfoSocAddr);
            f.syncUninterruptibly();
            this.httpsAddress = (InetSocketAddress)f.channel().localAddress();
            LOG.info("Listening HTTPS traffic on " + this.httpsAddress);
        }
    }

    @Override
    public void close() throws IOException {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
        if (this.externalHttpChannel != null) {
            this.externalHttpChannel.close();
        }
        try {
            this.infoServer.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String getHostnameForSpnegoPrincipal(Configuration conf) {
        String addr = conf.getTrimmed("dfs.datanode.http.address", null);
        if (addr == null) {
            addr = conf.getTrimmed("dfs.datanode.https.address", "0.0.0.0:50475");
        }
        InetSocketAddress inetSocker = NetUtils.createSocketAddr(addr);
        return inetSocker.getHostString();
    }
}

