/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class StorageLocation {
    final StorageType storageType;
    final File file;
    private static final Pattern regex = Pattern.compile("^\\[(\\w*)\\](.+)$");

    private StorageLocation(StorageType storageType, URI uri) {
        this.storageType = storageType;
        if (uri.getScheme() != null && !"file".equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported URI schema in " + uri);
        }
        this.file = new File(uri.getPath());
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    URI getUri() {
        return this.file.toURI();
    }

    public File getFile() {
        return this.file;
    }

    public static StorageLocation parse(String rawLocation) throws IOException, SecurityException {
        Matcher matcher = regex.matcher(rawLocation);
        StorageType storageType = StorageType.DEFAULT;
        String location = rawLocation;
        if (matcher.matches()) {
            String classString = matcher.group(1);
            location = matcher.group(2);
            if (!classString.isEmpty()) {
                storageType = StorageType.valueOf(StringUtils.toUpperCase(classString));
            }
        }
        return new StorageLocation(storageType, new Path(location).toUri());
    }

    public String toString() {
        return "[" + (Object)((Object)this.storageType) + "]" + this.file.toURI();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StorageLocation)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

