/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Options;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.MD5Hash;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.DataChecksum;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.znerd.xmlenc.XMLOutputter;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public class MD5MD5CRC32FileChecksum
extends FileChecksum {
    public static final int LENGTH = 28;
    private int bytesPerCRC;
    private long crcPerBlock;
    private MD5Hash md5;

    public MD5MD5CRC32FileChecksum() {
        this(0, 0L, null);
    }

    public MD5MD5CRC32FileChecksum(int bytesPerCRC, long crcPerBlock, MD5Hash md5) {
        this.bytesPerCRC = bytesPerCRC;
        this.crcPerBlock = crcPerBlock;
        this.md5 = md5;
    }

    @Override
    public String getAlgorithmName() {
        return "MD5-of-" + this.crcPerBlock + "MD5-of-" + this.bytesPerCRC + this.getCrcType().name();
    }

    public static DataChecksum.Type getCrcTypeFromAlgorithmName(String algorithm) throws IOException {
        if (algorithm.endsWith(DataChecksum.Type.CRC32.name())) {
            return DataChecksum.Type.CRC32;
        }
        if (algorithm.endsWith(DataChecksum.Type.CRC32C.name())) {
            return DataChecksum.Type.CRC32C;
        }
        throw new IOException("Unknown checksum type in " + algorithm);
    }

    @Override
    public int getLength() {
        return 28;
    }

    @Override
    public byte[] getBytes() {
        return WritableUtils.toByteArray(this);
    }

    public DataChecksum.Type getCrcType() {
        return DataChecksum.Type.CRC32;
    }

    @Override
    public Options.ChecksumOpt getChecksumOpt() {
        return new Options.ChecksumOpt(this.getCrcType(), this.bytesPerCRC);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.bytesPerCRC = in.readInt();
        this.crcPerBlock = in.readLong();
        this.md5 = MD5Hash.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bytesPerCRC);
        out.writeLong(this.crcPerBlock);
        this.md5.write(out);
    }

    public static void write(XMLOutputter xml, MD5MD5CRC32FileChecksum that) throws IOException {
        xml.startTag(MD5MD5CRC32FileChecksum.class.getName());
        if (that != null) {
            xml.attribute("bytesPerCRC", "" + that.bytesPerCRC);
            xml.attribute("crcPerBlock", "" + that.crcPerBlock);
            xml.attribute("crcType", "" + that.getCrcType().name());
            xml.attribute("md5", "" + that.md5);
        }
        xml.endTag();
    }

    public static MD5MD5CRC32FileChecksum valueOf(Attributes attrs) throws SAXException {
        String bytesPerCRC = attrs.getValue("bytesPerCRC");
        String crcPerBlock = attrs.getValue("crcPerBlock");
        String md5 = attrs.getValue("md5");
        String crcType = attrs.getValue("crcType");
        if (bytesPerCRC == null || crcPerBlock == null || md5 == null) {
            return null;
        }
        try {
            DataChecksum.Type finalCrcType = crcType == null || crcType.equals("") ? DataChecksum.Type.CRC32 : DataChecksum.Type.valueOf(crcType);
            switch (finalCrcType) {
                case CRC32: {
                    return new MD5MD5CRC32GzipFileChecksum(Integer.parseInt(bytesPerCRC), Integer.parseInt(crcPerBlock), new MD5Hash(md5));
                }
                case CRC32C: {
                    return new MD5MD5CRC32CastagnoliFileChecksum(Integer.parseInt(bytesPerCRC), Integer.parseInt(crcPerBlock), new MD5Hash(md5));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock + ", crcType=" + crcType + ", md5=" + md5, e);
        }
    }

    public String toString() {
        return this.getAlgorithmName() + ":" + this.md5;
    }
}

