/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFsRecoverable;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopRecoverableFsDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopRecoverableSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.util.Preconditions;

@Internal
public class HadoopRecoverableWriter
implements RecoverableWriter {
    private final FileSystem fs;

    public HadoopRecoverableWriter(FileSystem fs) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        if (!"hdfs".equalsIgnoreCase(fs.getScheme()) || !HadoopUtils.isMinHadoopVersion(2, 7)) {
            throw new UnsupportedOperationException("Recoverable writers on Hadoop are only supported for HDFS and for Hadoop version 2.7 or newer");
        }
    }

    public RecoverableFsDataOutputStream open(org.apache.flink.core.fs.Path filePath) throws IOException {
        Path targetFile = HadoopFileSystem.toHadoopPath(filePath);
        Path tempFile = HadoopRecoverableWriter.generateStagingTempFilePath(this.fs, targetFile);
        return new HadoopRecoverableFsDataOutputStream(this.fs, targetFile, tempFile);
    }

    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System cannot recover a recoverable for another file system: " + recoverable);
    }

    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream.HadoopFsCommitter(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System  cannot recover a recoverable for another file system: " + recoverable);
    }

    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    public boolean supportsResume() {
        return true;
    }

    @VisibleForTesting
    static Path generateStagingTempFilePath(FileSystem fs, Path targetFile) throws IOException {
        Path candidate;
        Preconditions.checkArgument((boolean)targetFile.isAbsolute(), (Object)"targetFile must be absolute");
        Path parent = targetFile.getParent();
        String name = targetFile.getName();
        Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (Object)"targetFile must not be the root directory");
        while (fs.exists(candidate = new Path(parent, "." + name + ".inprogress." + UUID.randomUUID().toString()))) {
        }
        return candidate;
    }
}

