/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopRecoverableWriter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.util.Preconditions;

public class HadoopFileSystem
extends org.apache.flink.core.fs.FileSystem {
    private final FileSystem fs;
    private FileSystemKind fsKind;

    public HadoopFileSystem(FileSystem hadoopFileSystem) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public org.apache.flink.core.fs.Path getWorkingDirectory() {
        return new org.apache.flink.core.fs.Path(this.fs.getWorkingDirectory().toUri());
    }

    public org.apache.flink.core.fs.Path getHomeDirectory() {
        return new org.apache.flink.core.fs.Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public FileStatus getFileStatus(org.apache.flink.core.fs.Path f) throws IOException {
        org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(HadoopFileSystem.toHadoopPath(f));
        return new HadoopFileStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(org.apache.flink.core.fs.Path f, int bufferSize) throws IOException {
        Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(org.apache.flink.core.fs.Path f) throws IOException {
        Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(org.apache.flink.core.fs.Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(org.apache.flink.core.fs.Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(org.apache.flink.core.fs.Path f, boolean recursive) throws IOException {
        return this.fs.delete(HadoopFileSystem.toHadoopPath(f), recursive);
    }

    public boolean exists(org.apache.flink.core.fs.Path f) throws IOException {
        return this.fs.exists(HadoopFileSystem.toHadoopPath(f));
    }

    public FileStatus[] listStatus(org.apache.flink.core.fs.Path f) throws IOException {
        org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(org.apache.flink.core.fs.Path f) throws IOException {
        return this.fs.mkdirs(HadoopFileSystem.toHadoopPath(f));
    }

    public boolean rename(org.apache.flink.core.fs.Path src, org.apache.flink.core.fs.Path dst) throws IOException {
        return this.fs.rename(HadoopFileSystem.toHadoopPath(src), HadoopFileSystem.toHadoopPath(dst));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public FileSystemKind getKind() {
        if (this.fsKind == null) {
            this.fsKind = HadoopFileSystem.getKindForScheme(this.fs.getUri().getScheme());
        }
        return this.fsKind;
    }

    public RecoverableWriter createRecoverableWriter() throws IOException {
        return new HadoopRecoverableWriter(this.fs);
    }

    static Path toHadoopPath(org.apache.flink.core.fs.Path path) {
        return new Path(path.toUri());
    }

    static FileSystemKind getKindForScheme(String scheme) {
        if ((scheme = scheme.toLowerCase(Locale.US)).startsWith("s3") || scheme.startsWith("emr")) {
            return FileSystemKind.OBJECT_STORE;
        }
        if (scheme.startsWith("http") || scheme.startsWith("ftp")) {
            return FileSystemKind.OBJECT_STORE;
        }
        return FileSystemKind.FILE_SYSTEM;
    }
}

