/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs;

import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.util.HadoopUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopConfigLoader.class);
    private final String[] flinkConfigPrefixes;
    private final String[][] mirroredConfigKeys;
    private final String hadoopConfigPrefix;
    private final Set<String> packagePrefixesToShade;
    private final Set<String> configKeysToShade;
    private final String flinkShadingPrefix;
    private Configuration flinkConfig;
    private org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration hadoopConfig;

    public HadoopConfigLoader(@Nonnull String[] flinkConfigPrefixes, @Nonnull String[][] mirroredConfigKeys, @Nonnull String hadoopConfigPrefix, Set<String> packagePrefixesToShade, @Nonnull Set<String> configKeysToShade, @Nonnull String flinkShadingPrefix) {
        this.flinkConfigPrefixes = flinkConfigPrefixes;
        this.mirroredConfigKeys = mirroredConfigKeys;
        this.hadoopConfigPrefix = hadoopConfigPrefix;
        this.packagePrefixesToShade = packagePrefixesToShade;
        this.configKeysToShade = configKeysToShade;
        this.flinkShadingPrefix = flinkShadingPrefix;
    }

    public void setFlinkConfig(Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration getOrLoadHadoopConfig() {
        org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration hadoopConfig = this.hadoopConfig;
        if (hadoopConfig == null) {
            if (this.flinkConfig != null) {
                hadoopConfig = this.mirrorCertainHadoopConfig(this.loadHadoopConfigFromFlink());
            } else {
                LOG.warn("Flink configuration is not set prior to loading this configuration. Using Hadoop configuration from the classpath.");
                hadoopConfig = new org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration();
            }
        }
        this.hadoopConfig = hadoopConfig;
        return hadoopConfig;
    }

    private org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration loadHadoopConfigFromFlink() {
        org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration hadoopConfig = HadoopUtils.getHadoopConfiguration(this.flinkConfig);
        for (String key : this.flinkConfig.keySet()) {
            for (String prefix : this.flinkConfigPrefixes) {
                if (!key.startsWith(prefix)) continue;
                String value = this.flinkConfig.getString(key, null);
                String newKey = this.hadoopConfigPrefix + key.substring(prefix.length());
                String newValue = this.fixHadoopConfig(key, this.flinkConfig.getString(key, null));
                hadoopConfig.set(newKey, newValue);
                LOG.debug("Adding Flink config entry for {} as {}={} to Hadoop config", new Object[]{key, newKey, value});
            }
        }
        return hadoopConfig;
    }

    private org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration mirrorCertainHadoopConfig(org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration hadoopConfig) {
        for (String[] mirrored : this.mirroredConfigKeys) {
            String value = hadoopConfig.get(mirrored[0], null);
            if (value == null) continue;
            hadoopConfig.set(mirrored[1], value);
        }
        return hadoopConfig;
    }

    private String fixHadoopConfig(String key, String value) {
        return key != null && this.configKeysToShade.contains(key) ? this.shadeClassConfig(value) : value;
    }

    private String shadeClassConfig(String classConfig) {
        return this.packagePrefixesToShade.stream().anyMatch(classConfig::startsWith) ? this.flinkShadingPrefix + classConfig : classConfig;
    }
}

