/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.SecurityUtil;

public class KerberosAuthentication {
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private final KerberosPrincipal principal;
    private final Configuration configuration;

    public KerberosAuthentication(String principal, String keytabLocation) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(keytabLocation, "keytabLocation is null");
        Path keytabPath = Paths.get(keytabLocation, new String[0]);
        Preconditions.checkArgument(Files.exists(keytabPath, new LinkOption[0]), "keytab does not exist: " + keytabLocation);
        Preconditions.checkArgument(Files.isReadable(keytabPath), "keytab is not readable: " + keytabLocation);
        this.principal = KerberosAuthentication.createKerberosPrincipal(principal);
        this.configuration = KerberosAuthentication.createConfiguration(this.principal.getName(), keytabLocation);
    }

    public Subject getSubject() {
        Subject subject = new Subject(false, ImmutableSet.of(this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw Throwables.propagate(e);
        }
    }

    private static KerberosPrincipal createKerberosPrincipal(String principal) {
        try {
            return new KerberosPrincipal(SecurityUtil.getServerPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private static Configuration createConfiguration(String principal, String keytabLocation) {
        final ImmutableMap<String, String> options = ImmutableMap.builder().put("useKeyTab", "true").put("storeKey", "true").put("doNotPrompt", "true").put("isInitiator", "true").put("principal", principal).put("keyTab", keytabLocation).build();
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosAuthentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
    }
}

