/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveWriteUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.StorageFormat;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Page;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Splitter;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.Serializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.columnar.OptimizedLazyBinaryColumnarSerde;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;

public class RecordFileWriter
implements HiveFileWriter {
    private final Path path;
    private final JobConf conf;
    private final int fieldCount;
    private final Serializer serializer;
    private final FileSinkOperator.RecordWriter recordWriter;
    private final SettableStructObjectInspector tableInspector;
    private final List<StructField> structFields;
    private final Object row;
    private final HiveWriteUtils.FieldSetter[] setters;
    private final long estimatedWriterSystemMemoryUsage;

    public RecordFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, DataSize estimatedWriterSystemMemoryUsage, JobConf conf, TypeManager typeManager) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.conf = Objects.requireNonNull(conf, "conf is null");
        List<String> fileColumnNames = Splitter.on(',').trimResults().omitEmptyStrings().splitToList(schema.getProperty("columns", ""));
        List<Type> fileColumnTypes = HiveType.toHiveTypes(schema.getProperty("columns.types", "")).stream().map(hiveType -> hiveType.getType(typeManager)).collect(Collectors.toList());
        this.fieldCount = fileColumnNames.size();
        String serDe = storageFormat.getSerDe();
        if (serDe.equals(LazyBinaryColumnarSerDe.class.getName())) {
            serDe = OptimizedLazyBinaryColumnarSerde.class.getName();
        }
        this.serializer = RecordFileWriter.initializeSerializer(conf, schema, serDe);
        this.recordWriter = HiveWriteUtils.createRecordWriter(path, conf, schema, storageFormat.getOutputFormat());
        List<ObjectInspector> objectInspectors = HiveWriteUtils.getRowColumnInspectors(fileColumnTypes);
        this.tableInspector = ObjectInspectorFactory.getStandardStructObjectInspector(fileColumnNames, objectInspectors);
        this.structFields = ImmutableList.copyOf(inputColumnNames.stream().map(arg_0 -> ((SettableStructObjectInspector)this.tableInspector).getStructFieldRef(arg_0)).collect(Collectors.toList()));
        this.row = this.tableInspector.create();
        this.setters = new HiveWriteUtils.FieldSetter[this.structFields.size()];
        for (int i = 0; i < this.setters.length; ++i) {
            this.setters[i] = HiveWriteUtils.createFieldSetter(this.tableInspector, this.row, this.structFields.get(i), fileColumnTypes.get(this.structFields.get(i).getFieldID()));
        }
        this.estimatedWriterSystemMemoryUsage = estimatedWriterSystemMemoryUsage.toBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return this.estimatedWriterSystemMemoryUsage;
    }

    @Override
    public void appendRows(Page dataPage) {
        for (int position = 0; position < dataPage.getPositionCount(); ++position) {
            this.appendRow(dataPage, position);
        }
    }

    public void appendRow(Page dataPage, int position) {
        for (int field = 0; field < this.fieldCount; ++field) {
            Block block = dataPage.getBlock(field);
            if (block.isNull(position)) {
                this.tableInspector.setStructFieldData(this.row, this.structFields.get(field), null);
                continue;
            }
            this.setters[field].setField(block, position);
        }
        try {
            this.recordWriter.write(this.serializer.serialize(this.row, (ObjectInspector)this.tableInspector));
        }
        catch (IOException | SerDeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, e);
        }
    }

    @Override
    public void commit() {
        try {
            this.recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.recordWriter.close(true);
            }
            finally {
                this.path.getFileSystem(this.conf).delete(this.path, false);
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    private static Serializer initializeSerializer(Configuration conf, Properties properties, String serializerName) {
        try {
            Serializer result = (Serializer)Class.forName(serializerName).getConstructor(new Class[0]).newInstance(new Object[0]);
            result.initialize(conf, properties);
            return result;
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw Throwables.propagate(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.path).toString();
    }
}

