/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry;

import java.util.Random;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.RetryUtils;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.V2CompatibleBackoffStrategyAdapter;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.v2.BackoffStrategy;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.v2.RetryPolicyContext;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.ValidationUtils;

public class PredefinedBackoffStrategies {
    private static final int SDK_DEFAULT_BASE_DELAY = 100;
    static final int SDK_DEFAULT_THROTTLED_BASE_DELAY = 500;
    static final int SDK_DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    static final int DYNAMODB_DEFAULT_BASE_DELAY = 25;
    private static final int MAX_RETRIES = 30;

    private static int calculateExponentialDelay(int retriesAttempted, int baseDelay, int maxBackoffTime) {
        int retries = Math.min(retriesAttempted, 30);
        return (int)Math.min((1L << retries) * (long)baseDelay, (long)maxBackoffTime);
    }

    static class SDKDefaultBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final BackoffStrategy fullJitterBackoffStrategy;
        private final BackoffStrategy equalJitterBackoffStrategy;

        SDKDefaultBackoffStrategy() {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(100, 20000);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(500, 20000);
        }

        SDKDefaultBackoffStrategy(int baseDelay, int throttledBaseDelay, int maxBackoff) {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(baseDelay, maxBackoff);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(throttledBaseDelay, maxBackoff);
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
            if (RetryUtils.isThrottlingException(context.exception())) {
                return this.equalJitterBackoffStrategy.computeDelayBeforeNextRetry(context);
            }
            return this.fullJitterBackoffStrategy.computeDelayBeforeNextRetry(context);
        }
    }

    public static class ExponentialBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;

        public ExponentialBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
            return PredefinedBackoffStrategies.calculateExponentialDelay(context.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
        }
    }

    public static class EqualJitterBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random = new Random();

        public EqualJitterBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
            int ceil = PredefinedBackoffStrategies.calculateExponentialDelay(context.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return ceil / 2 + this.random.nextInt(ceil / 2 + 1);
        }
    }

    public static class FullJitterBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random = new Random();

        public FullJitterBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIsPositive(baseDelay, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(maxBackoffTime, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
            int ceil = PredefinedBackoffStrategies.calculateExponentialDelay(context.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return this.random.nextInt(ceil);
        }
    }
}

