/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.AbstractFileSystemFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopConfigLoader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.util.FlinkRuntimeException;

public class S3FileSystemFactory
extends AbstractFileSystemFactory {
    private static final Set<String> PACKAGE_PREFIXES_TO_SHADE = new HashSet<String>(Collections.singletonList("org.apache.flink.fs.s3presto.shaded.com.amazonaws."));
    private static final Set<String> CONFIG_KEYS_TO_SHADE = Collections.unmodifiableSet(new HashSet<String>(Collections.singleton("presto.s3.credentials-provider")));
    private static final String FLINK_SHADING_PREFIX = "org.apache.flink.fs.s3presto.shaded.";
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"s3.", "presto.s3."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"presto.s3.access.key", "presto.s3.access-key"}, {"presto.s3.secret.key", "presto.s3.secret-key"}};

    public S3FileSystemFactory() {
        super("Presto S3 File System", S3FileSystemFactory.createHadoopConfigLoader());
    }

    public String getScheme() {
        return "s3";
    }

    @VisibleForTesting
    static HadoopConfigLoader createHadoopConfigLoader() {
        return new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, "presto.s3.", PACKAGE_PREFIXES_TO_SHADE, CONFIG_KEYS_TO_SHADE, FLINK_SHADING_PREFIX);
    }

    @Override
    protected FileSystem createHadoopFileSystem() {
        return new PrestoS3FileSystem();
    }

    @Override
    protected URI getInitURI(URI fsUri, Configuration hadoopConfig) {
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        URI initUri = scheme == null && authority == null ? this.createURI("s3://s3.amazonaws.com") : (scheme != null && authority == null ? this.createURI(scheme + "://s3.amazonaws.com") : fsUri);
        return initUri;
    }

    private URI createURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new FlinkRuntimeException("Error in s3 aws URI - " + str, (Throwable)e);
        }
    }
}

