/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configured;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ipc.RPC;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.NetUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.tools.GetUserMappingsProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Tool;

public abstract class GetGroupsBase
extends Configured
implements Tool {
    private PrintStream out;

    protected GetGroupsBase(Configuration conf) {
        this(conf, System.out);
    }

    protected GetGroupsBase(Configuration conf, PrintStream out) {
        super(conf);
        this.out = out;
    }

    @Override
    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{UserGroupInformation.getCurrentUser().getUserName()};
        }
        for (String username : args) {
            StringBuilder sb = new StringBuilder();
            sb.append(username + " :");
            for (String group : this.getUgmProtocol().getGroupsForUser(username)) {
                sb.append(" ");
                sb.append(group);
            }
            this.out.println(sb);
        }
        return 0;
    }

    protected abstract InetSocketAddress getProtocolAddress(Configuration var1) throws IOException;

    protected GetUserMappingsProtocol getUgmProtocol() throws IOException {
        GetUserMappingsProtocol userGroupMappingProtocol = RPC.getProxy(GetUserMappingsProtocol.class, 1L, this.getProtocolAddress(this.getConf()), UserGroupInformation.getCurrentUser(), this.getConf(), NetUtils.getSocketFactory(this.getConf(), GetUserMappingsProtocol.class));
        return userGroupMappingProtocol;
    }
}

