/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.output;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.BytesWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.SequenceFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Job;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileAsBinaryOutputFormat
extends SequenceFileOutputFormat<BytesWritable, BytesWritable> {
    public static String KEY_CLASS = "mapreduce.output.seqbinaryoutputformat.key.class";
    public static String VALUE_CLASS = "mapreduce.output.seqbinaryoutputformat.value.class";

    public static void setSequenceFileOutputKeyClass(Job job, Class<?> theClass) {
        job.getConfiguration().setClass(KEY_CLASS, theClass, Object.class);
    }

    public static void setSequenceFileOutputValueClass(Job job, Class<?> theClass) {
        job.getConfiguration().setClass(VALUE_CLASS, theClass, Object.class);
    }

    public static Class<? extends WritableComparable> getSequenceFileOutputKeyClass(JobContext job) {
        return job.getConfiguration().getClass(KEY_CLASS, job.getOutputKeyClass().asSubclass(WritableComparable.class), WritableComparable.class);
    }

    public static Class<? extends Writable> getSequenceFileOutputValueClass(JobContext job) {
        return job.getConfiguration().getClass(VALUE_CLASS, job.getOutputValueClass().asSubclass(Writable.class), Writable.class);
    }

    @Override
    public RecordWriter<BytesWritable, BytesWritable> getRecordWriter(TaskAttemptContext context) throws IOException {
        final SequenceFile.Writer out = this.getSequenceWriter(context, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(context), SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(context));
        return new RecordWriter<BytesWritable, BytesWritable>(){
            private WritableValueBytes wvaluebytes = new WritableValueBytes();

            @Override
            public void write(BytesWritable bkey, BytesWritable bvalue) throws IOException {
                this.wvaluebytes.reset(bvalue);
                out.appendRaw(bkey.getBytes(), 0, bkey.getLength(), this.wvaluebytes);
                this.wvaluebytes.reset(null);
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException {
                out.close();
            }
        };
    }

    @Override
    public void checkOutputSpecs(JobContext job) throws IOException {
        super.checkOutputSpecs(job);
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job) && SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job) == SequenceFile.CompressionType.RECORD) {
            throw new InvalidJobConfException("SequenceFileAsBinaryOutputFormat doesn't support Record Compression");
        }
    }

    public static class WritableValueBytes
    implements SequenceFile.ValueBytes {
        private BytesWritable value;

        public WritableValueBytes() {
            this.value = null;
        }

        public WritableValueBytes(BytesWritable value) {
            this.value = value;
        }

        public void reset(BytesWritable value) {
            this.value = value;
        }

        @Override
        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
            outStream.write(this.value.getBytes(), 0, this.value.getLength());
        }

        @Override
        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException("WritableValueBytes doesn't support RECORD compression");
        }

        @Override
        public int getSize() {
            return this.value.getLength();
        }
    }
}

