/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.DataChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

public class ReplicaInPipeline
extends ReplicaInfo
implements ReplicaInPipelineInterface {
    private long bytesAcked;
    private long bytesOnDisk;
    private byte[] lastChecksum;
    private Thread writer;
    private long bytesReserved;

    public ReplicaInPipeline(long blockId, long genStamp, FsVolumeSpi vol, File dir, long bytesToReserve) {
        this(blockId, 0L, genStamp, vol, dir, Thread.currentThread(), bytesToReserve);
    }

    ReplicaInPipeline(Block block, FsVolumeSpi vol, File dir, Thread writer) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir, writer, 0L);
    }

    ReplicaInPipeline(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir, Thread writer, long bytesToReserve) {
        super(blockId, len, genStamp, vol, dir);
        this.bytesAcked = len;
        this.bytesOnDisk = len;
        this.writer = writer;
        this.bytesReserved = bytesToReserve;
    }

    public ReplicaInPipeline(ReplicaInPipeline from) {
        super(from);
        this.bytesAcked = from.getBytesAcked();
        this.bytesOnDisk = from.getBytesOnDisk();
        this.writer = from.writer;
        this.bytesReserved = from.bytesReserved;
    }

    @Override
    public long getVisibleLength() {
        return -1L;
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.TEMPORARY;
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public void setBytesAcked(long bytesAcked) {
        long newBytesAcked = bytesAcked - this.bytesAcked;
        this.bytesAcked = bytesAcked;
        this.getVolume().releaseReservedSpace(newBytesAcked);
        this.bytesReserved -= newBytesAcked;
    }

    @Override
    public long getBytesOnDisk() {
        return this.bytesOnDisk;
    }

    @Override
    public long getBytesReserved() {
        return this.bytesReserved;
    }

    @Override
    public void releaseAllBytesReserved() {
        this.getVolume().releaseReservedSpace(this.bytesReserved);
        this.bytesReserved = 0L;
    }

    @Override
    public synchronized void setLastChecksumAndDataLen(long dataLength, byte[] lastChecksum) {
        this.bytesOnDisk = dataLength;
        this.lastChecksum = lastChecksum;
    }

    @Override
    public synchronized ChunkChecksum getLastChecksumAndDataLen() {
        return new ChunkChecksum(this.getBytesOnDisk(), this.lastChecksum);
    }

    public void setWriter(Thread writer) {
        this.writer = writer;
    }

    public void interruptThread() {
        if (this.writer != null && this.writer != Thread.currentThread() && this.writer.isAlive()) {
            this.writer.interrupt();
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    public void stopWriter(long xceiverStopTimeout) throws IOException {
        if (this.writer != null && this.writer != Thread.currentThread() && this.writer.isAlive()) {
            this.writer.interrupt();
            try {
                this.writer.join(xceiverStopTimeout);
                if (this.writer.isAlive()) {
                    String msg = "Join on writer thread " + this.writer + " timed out";
                    DataNode.LOG.warn(msg + "\n" + StringUtils.getStackTrace(this.writer));
                    throw new IOException(msg);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Waiting for writer thread is interrupted.");
            }
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaOutputStreams createStreams(boolean isCreate, DataChecksum requestedChecksum) throws IOException {
        DataChecksum checksum;
        File blockFile = this.getBlockFile();
        File metaFile = this.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug("writeTo blockfile is " + blockFile + " of size " + blockFile.length());
            DataNode.LOG.debug("writeTo metafile is " + metaFile + " of size " + metaFile.length());
        }
        long blockDiskSize = 0L;
        long crcDiskSize = 0L;
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        if (!isCreate) {
            boolean checkedMeta = false;
            try {
                BlockMetadataHeader header = BlockMetadataHeader.readHeader(metaRAF);
                checksum = header.getChecksum();
                if (checksum.getBytesPerChecksum() != requestedChecksum.getBytesPerChecksum()) {
                    throw new IOException("Client requested checksum " + requestedChecksum + " when appending to an existing block " + "with different chunk size: " + checksum);
                }
                int bytesPerChunk = checksum.getBytesPerChecksum();
                int checksumSize = checksum.getChecksumSize();
                blockDiskSize = this.bytesOnDisk;
                crcDiskSize = (long)BlockMetadataHeader.getHeaderSize() + (blockDiskSize + (long)bytesPerChunk - 1L) / (long)bytesPerChunk * (long)checksumSize;
                if (blockDiskSize > 0L && (blockDiskSize > blockFile.length() || crcDiskSize > metaFile.length())) {
                    throw new IOException("Corrupted block: " + this);
                }
                checkedMeta = true;
            }
            finally {
                if (!checkedMeta) {
                    IOUtils.closeStream(metaRAF);
                }
            }
        } else {
            checksum = requestedChecksum;
        }
        FileOutputStream blockOut = null;
        FileOutputStream crcOut = null;
        try {
            blockOut = new FileOutputStream(new RandomAccessFile(blockFile, "rw").getFD());
            crcOut = new FileOutputStream(metaRAF.getFD());
            if (!isCreate) {
                blockOut.getChannel().position(blockDiskSize);
                crcOut.getChannel().position(crcDiskSize);
            }
            return new ReplicaOutputStreams(blockOut, crcOut, checksum, this.getVolume().isTransientStorage());
        }
        catch (IOException e) {
            IOUtils.closeStream(blockOut);
            IOUtils.closeStream(metaRAF);
            throw e;
        }
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bytesAcked=" + this.bytesAcked + "\n  bytesOnDisk=" + this.bytesOnDisk;
    }
}

