/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.metrics2.lib.MutableQuantiles;

@Metrics(about="Journal metrics", context="dfs")
class JournalMetrics {
    final MetricsRegistry registry = new MetricsRegistry("JournalNode");
    @Metric(value={"Number of batches written since startup"})
    MutableCounterLong batchesWritten;
    @Metric(value={"Number of txns written since startup"})
    MutableCounterLong txnsWritten;
    @Metric(value={"Number of bytes written since startup"})
    MutableCounterLong bytesWritten;
    @Metric(value={"Number of batches written where this node was lagging"})
    MutableCounterLong batchesWrittenWhileLagging;
    private final int[] QUANTILE_INTERVALS = new int[]{60, 300, 3600};
    final MutableQuantiles[] syncsQuantiles;
    private final Journal journal;

    JournalMetrics(Journal journal) {
        this.journal = journal;
        this.syncsQuantiles = new MutableQuantiles[this.QUANTILE_INTERVALS.length];
        for (int i = 0; i < this.syncsQuantiles.length; ++i) {
            int interval = this.QUANTILE_INTERVALS[i];
            this.syncsQuantiles[i] = this.registry.newQuantiles("syncs" + interval + "s", "Journal sync time", "ops", "latencyMicros", interval);
        }
    }

    public static JournalMetrics create(Journal j) {
        JournalMetrics m = new JournalMetrics(j);
        return DefaultMetricsSystem.instance().register(m.getName(), null, m);
    }

    String getName() {
        return "Journal-" + this.journal.getJournalId();
    }

    @Metric(value={"Current writer's epoch"})
    public long getLastWriterEpoch() {
        try {
            return this.journal.getLastWriterEpoch();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Metric(value={"Last accepted epoch"})
    public long getLastPromisedEpoch() {
        try {
            return this.journal.getLastPromisedEpoch();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Metric(value={"The highest txid stored on this JN"})
    public long getLastWrittenTxId() {
        return this.journal.getHighestWrittenTxId();
    }

    @Metric(value={"Number of transactions that this JN is lagging"})
    public long getCurrentLagTxns() {
        try {
            return this.journal.getCurrentLagTxns();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    void addSync(long us) {
        for (MutableQuantiles q : this.syncsQuantiles) {
            q.add(us);
        }
    }
}

