/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FsServerDefaults;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FsStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Options;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class DelegateToFileSystem
extends AbstractFileSystem {
    protected final FileSystem fsImpl;

    protected DelegateToFileSystem(URI theUri, FileSystem theFsImpl, Configuration conf, String supportedScheme, boolean authorityRequired) throws IOException, URISyntaxException {
        super(theUri, supportedScheme, authorityRequired, DelegateToFileSystem.getDefaultPortIfDefined(theFsImpl));
        this.fsImpl = theFsImpl;
        this.fsImpl.initialize(theUri, conf);
        this.fsImpl.statistics = this.getStatistics();
    }

    private static int getDefaultPortIfDefined(FileSystem theFsImpl) {
        int defaultPort = theFsImpl.getDefaultPort();
        return defaultPort != 0 ? defaultPort : -1;
    }

    @Override
    public Path getInitialWorkingDirectory() {
        return this.fsImpl.getInitialWorkingDirectory();
    }

    @Override
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        this.checkPath(f);
        if (!createParent) {
            FileStatus stat = this.getFileStatus(f.getParent());
            if (stat == null) {
                throw new FileNotFoundException("Missing parent:" + f);
            }
            if (!stat.isDirectory()) {
                throw new ParentNotDirectoryException("parent is not a dir:" + f);
            }
        }
        return this.fsImpl.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        this.checkPath(f);
        return this.fsImpl.delete(f, recursive);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileBlockLocations(f, start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileChecksum(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.getFileStatus(f);
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        FileStatus status = this.fsImpl.getFileLinkStatus(f);
        if (status.isSymlink()) {
            status.setSymlink(this.fsImpl.getLinkTarget(f));
        }
        return status;
    }

    @Override
    public FsStatus getFsStatus() throws IOException {
        return this.fsImpl.getStatus();
    }

    @Override
    public FsStatus getFsStatus(Path f) throws IOException {
        return this.fsImpl.getStatus(f);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fsImpl.getServerDefaults();
    }

    @Override
    public Path getHomeDirectory() {
        return this.fsImpl.getHomeDirectory();
    }

    @Override
    public int getUriDefaultPort() {
        return 0;
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        this.checkPath(f);
        return this.fsImpl.listStatus(f);
    }

    @Override
    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        this.checkPath(dir);
        this.fsImpl.primitiveMkdir(dir, permission, createParent);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.checkPath(f);
        return this.fsImpl.open(f, bufferSize);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        this.checkPath(f);
        return this.fsImpl.truncate(f, newLength);
    }

    @Override
    public void renameInternal(Path src, Path dst) throws IOException {
        this.checkPath(src);
        this.checkPath(dst);
        this.fsImpl.rename(src, dst, Options.Rename.NONE);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException {
        this.checkPath(f);
        this.fsImpl.setOwner(f, username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException {
        this.checkPath(f);
        this.fsImpl.setPermission(f, permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException {
        this.checkPath(f);
        return this.fsImpl.setReplication(f, replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException {
        this.checkPath(f);
        this.fsImpl.setTimes(f, mtime, atime);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.fsImpl.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public boolean supportsSymlinks() {
        return this.fsImpl.supportsSymlinks();
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fsImpl.createSymlink(target, link, createParent);
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return this.fsImpl.getLinkTarget(f);
    }

    @Override
    public String getCanonicalServiceName() {
        return this.fsImpl.getCanonicalServiceName();
    }

    @Override
    public List<Token<?>> getDelegationTokens(String renewer) throws IOException {
        return Arrays.asList(this.fsImpl.addDelegationTokens(renewer, null));
    }
}

