/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Shell;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ScriptBasedMapping
extends CachedDNSToSwitchMapping {
    static final int MIN_ALLOWABLE_ARGS = 1;
    static final int DEFAULT_ARG_COUNT = 100;
    static final String SCRIPT_FILENAME_KEY = "net.topology.script.file.name";
    static final String SCRIPT_ARG_COUNT_KEY = "net.topology.script.number.args";
    public static final String NO_SCRIPT = "no script";

    public ScriptBasedMapping() {
        this(new RawScriptBasedMapping());
    }

    public ScriptBasedMapping(DNSToSwitchMapping rawMap) {
        super(rawMap);
    }

    public ScriptBasedMapping(Configuration conf) {
        this();
        this.setConf(conf);
    }

    private RawScriptBasedMapping getRawMapping() {
        return (RawScriptBasedMapping)this.rawMapping;
    }

    @Override
    public Configuration getConf() {
        return this.getRawMapping().getConf();
    }

    @Override
    public String toString() {
        return "script-based mapping with " + this.getRawMapping().toString();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.getRawMapping().setConf(conf);
    }

    protected static class RawScriptBasedMapping
    extends AbstractDNSToSwitchMapping {
        private String scriptName;
        private int maxArgs;
        private static final Log LOG = LogFactory.getLog(ScriptBasedMapping.class);

        @Override
        public void setConf(Configuration conf) {
            super.setConf(conf);
            if (conf != null) {
                this.scriptName = conf.get(ScriptBasedMapping.SCRIPT_FILENAME_KEY);
                this.maxArgs = conf.getInt(ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY, 100);
            } else {
                this.scriptName = null;
                this.maxArgs = 0;
            }
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> m = new ArrayList<String>(names.size());
            if (names.isEmpty()) {
                return m;
            }
            if (this.scriptName == null) {
                for (String name : names) {
                    m.add("/default-rack");
                }
                return m;
            }
            String output = this.runResolveCommand(names, this.scriptName);
            if (output != null) {
                StringTokenizer allSwitchInfo = new StringTokenizer(output);
                while (allSwitchInfo.hasMoreTokens()) {
                    String switchInfo = allSwitchInfo.nextToken();
                    m.add(switchInfo);
                }
                if (m.size() != names.size()) {
                    LOG.error("Script " + this.scriptName + " returned " + Integer.toString(m.size()) + " values when " + Integer.toString(names.size()) + " were expected.");
                    return null;
                }
            } else {
                return null;
            }
            return m;
        }

        protected String runResolveCommand(List<String> args, String commandScriptName) {
            int loopCount = 0;
            if (args.size() == 0) {
                return null;
            }
            StringBuilder allOutput = new StringBuilder();
            int numProcessed = 0;
            if (this.maxArgs < 1) {
                LOG.warn("Invalid value " + Integer.toString(this.maxArgs) + " for " + ScriptBasedMapping.SCRIPT_ARG_COUNT_KEY + "; must be >= " + Integer.toString(1));
                return null;
            }
            while (numProcessed != args.size()) {
                int start = this.maxArgs * loopCount;
                ArrayList<String> cmdList = new ArrayList<String>();
                cmdList.add(commandScriptName);
                for (numProcessed = start; numProcessed < start + this.maxArgs && numProcessed < args.size(); ++numProcessed) {
                    cmdList.add(args.get(numProcessed));
                }
                File dir = null;
                String userDir = System.getProperty("user.dir");
                if (userDir != null) {
                    dir = new File(userDir);
                }
                Shell.ShellCommandExecutor s = new Shell.ShellCommandExecutor(cmdList.toArray(new String[cmdList.size()]), dir);
                try {
                    s.execute();
                    allOutput.append(s.getOutput()).append(" ");
                }
                catch (Exception e) {
                    LOG.warn("Exception running " + s, e);
                    return null;
                }
                ++loopCount;
            }
            return allOutput.toString();
        }

        @Override
        public boolean isSingleSwitch() {
            return this.scriptName == null;
        }

        public String toString() {
            return this.scriptName != null ? "script " + this.scriptName : ScriptBasedMapping.NO_SCRIPT;
        }

        @Override
        public void reloadCachedMappings() {
        }

        @Override
        public void reloadCachedMappings(List<String> names) {
        }
    }
}

