/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.RecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.KeyValueLineRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyValueTextInputFormat
extends FileInputFormat<Text, Text> {
    @Override
    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }

    @Override
    public RecordReader<Text, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        context.setStatus(genericSplit.toString());
        return new KeyValueLineRecordReader(context.getConfiguration());
    }
}

