/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.counters;

import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Lists;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Maps;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Counter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobCounter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.counters.Limits;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.util.ResourceBundles;

@InterfaceAudience.Private
public abstract class CounterGroupFactory<C extends Counter, G extends CounterGroupBase<C>> {
    private static final Map<String, Integer> s2i = Maps.newHashMap();
    private static final List<String> i2s = Lists.newArrayList();
    private static final int VERSION = 1;
    private static final String FS_GROUP_NAME = FileSystemCounter.class.getName();
    private final Map<String, FrameworkGroupFactory<G>> fmap = Maps.newHashMap();

    public CounterGroupFactory() {
        this.addFrameworkGroup(TaskCounter.class);
        this.addFrameworkGroup(JobCounter.class);
    }

    private synchronized <T extends Enum<T>> void addFrameworkGroup(Class<T> cls) {
        CounterGroupFactory.updateFrameworkGroupMapping(cls);
        this.fmap.put(cls.getName(), this.newFrameworkGroupFactory(cls));
    }

    private static synchronized void updateFrameworkGroupMapping(Class<?> cls) {
        String name = cls.getName();
        Integer i = s2i.get(name);
        if (i != null) {
            return;
        }
        i2s.add(name);
        s2i.put(name, i2s.size() - 1);
    }

    protected abstract <T extends Enum<T>> FrameworkGroupFactory<G> newFrameworkGroupFactory(Class<T> var1);

    public G newGroup(String name, Limits limits) {
        return this.newGroup(name, ResourceBundles.getCounterGroupName(name, name), limits);
    }

    public G newGroup(String name, String displayName, Limits limits) {
        FrameworkGroupFactory<G> gf = this.fmap.get(name);
        if (gf != null) {
            return (G)((CounterGroupBase)gf.newGroup(name));
        }
        if (name.equals(FS_GROUP_NAME)) {
            return this.newFileSystemGroup();
        }
        if (s2i.get(name) != null) {
            return this.newFrameworkGroup(s2i.get(name));
        }
        return this.newGenericGroup(name, displayName, limits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public G newFrameworkGroup(int id) {
        Class<CounterGroupFactory> clazz = CounterGroupFactory.class;
        synchronized (CounterGroupFactory.class) {
            if (id < 0 || id >= i2s.size()) {
                CounterGroupFactory.throwBadFrameGroupIdException(id);
            }
            String name = i2s.get(id);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            FrameworkGroupFactory<G> gf = this.fmap.get(name);
            if (gf == null) {
                CounterGroupFactory.throwBadFrameGroupIdException(id);
            }
            return (G)((CounterGroupBase)gf.newGroup(name));
        }
    }

    public static synchronized int getFrameworkGroupId(String name) {
        Integer i = s2i.get(name);
        if (i == null) {
            CounterGroupFactory.throwBadFrameworkGroupNameException(name);
        }
        return i;
    }

    public int version() {
        return 1;
    }

    public static synchronized boolean isFrameworkGroup(String name) {
        return s2i.get(name) != null || name.equals(FS_GROUP_NAME);
    }

    private static void throwBadFrameGroupIdException(int id) {
        throw new IllegalArgumentException("bad framework group id: " + id);
    }

    private static void throwBadFrameworkGroupNameException(String name) {
        throw new IllegalArgumentException("bad framework group name: " + name);
    }

    protected abstract G newGenericGroup(String var1, String var2, Limits var3);

    protected abstract G newFileSystemGroup();

    public static interface FrameworkGroupFactory<F> {
        public F newGroup(String var1);
    }
}

