/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Iterators;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.slf4j.Logger;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.inotify.EventBatch;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.inotify.MissingEventsException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Sampler;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Trace;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.TraceScope;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DFSInotifyEventInputStream {
    public static Logger LOG = LoggerFactory.getLogger(DFSInotifyEventInputStream.class);
    private final Sampler<?> traceSampler;
    private final ClientProtocol namenode;
    private Iterator<EventBatch> it;
    private long lastReadTxid;
    private long syncTxid;
    private Random rng = new Random();
    private static final int INITIAL_WAIT_MS = 10;

    DFSInotifyEventInputStream(Sampler<?> traceSampler, ClientProtocol namenode) throws IOException {
        this(traceSampler, namenode, namenode.getCurrentEditLogTxid());
    }

    DFSInotifyEventInputStream(Sampler traceSampler, ClientProtocol namenode, long lastReadTxid) throws IOException {
        this.traceSampler = traceSampler;
        this.namenode = namenode;
        this.it = Iterators.emptyIterator();
        this.lastReadTxid = lastReadTxid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBatch poll() throws IOException, MissingEventsException {
        try (TraceScope scope = Trace.startSpan("inotifyPoll", this.traceSampler);){
            EventBatch eventBatch;
            if (this.lastReadTxid == -1L) {
                LOG.debug("poll(): lastReadTxid is -1, reading current txid from NN");
                this.lastReadTxid = this.namenode.getCurrentEditLogTxid();
                EventBatch eventBatch2 = null;
                return eventBatch2;
            }
            if (!this.it.hasNext()) {
                EventBatchList el = this.namenode.getEditsFromTxid(this.lastReadTxid + 1L);
                if (el.getLastTxid() != -1L) {
                    this.syncTxid = el.getSyncTxid();
                    this.it = el.getBatches().iterator();
                    long formerLastReadTxid = this.lastReadTxid;
                    this.lastReadTxid = el.getLastTxid();
                    if (el.getFirstTxid() != formerLastReadTxid + 1L) {
                        throw new MissingEventsException(formerLastReadTxid + 1L, el.getFirstTxid());
                    }
                } else {
                    LOG.debug("poll(): read no edits from the NN when requesting edits after txid {}", (Object)this.lastReadTxid);
                    EventBatch eventBatch3 = null;
                    return eventBatch3;
                }
            }
            if (this.it.hasNext()) {
                eventBatch = this.it.next();
                return eventBatch;
            }
            eventBatch = null;
            return eventBatch;
        }
    }

    public long getTxidsBehindEstimate() {
        if (this.syncTxid == 0L) {
            return -1L;
        }
        assert (this.syncTxid >= this.lastReadTxid);
        return this.syncTxid - this.lastReadTxid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBatch poll(long time, TimeUnit tu) throws IOException, InterruptedException, MissingEventsException {
        EventBatch next = null;
        try (TraceScope scope = Trace.startSpan("inotifyPollWithTimeout", this.traceSampler);){
            long initialTime = Time.monotonicNow();
            long totalWait = TimeUnit.MILLISECONDS.convert(time, tu);
            long nextWait = 10L;
            while ((next = this.poll()) == null) {
                long timeLeft = totalWait - (Time.monotonicNow() - initialTime);
                if (timeLeft <= 0L) {
                    LOG.debug("timed poll(): timed out");
                    break;
                }
                nextWait = timeLeft < nextWait * 2L ? timeLeft : (nextWait *= 2L);
                LOG.debug("timed poll(): poll() returned null, sleeping for {} ms", (Object)nextWait);
                Thread.sleep(nextWait);
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBatch take() throws IOException, InterruptedException, MissingEventsException {
        EventBatch next = null;
        try (TraceScope scope = Trace.startSpan("inotifyTake", this.traceSampler);){
            int nextWaitMin = 10;
            while ((next = this.poll()) == null) {
                int sleepTime = nextWaitMin + this.rng.nextInt(nextWaitMin);
                LOG.debug("take(): poll() returned null, sleeping for {} ms", (Object)sleepTime);
                Thread.sleep(sleepTime);
                nextWaitMin = Math.min(60000, nextWaitMin * 2);
            }
        }
        return next;
    }
}

