/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.HadoopFileStatus;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ConcurrentLazyQueue;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.DirectoryLister;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketing;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePartitionKey;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePartitionMetadata;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSessionProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSplit;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSplitLoader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSplitSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.NamenodeStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Column;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.MetastoreUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Partition;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Table;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.ConfigurationUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.HiveFileIterator;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.ResumableTask;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.ResumableTasks;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.HostAddress;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.StandardErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.Domain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.AbstractIterator;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Iterators;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.PeekingIterator;
import org.apache.flink.fs.s3presto.shaded.com.google.common.io.CharStreams;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.common.FileUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.FileInputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.FileSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.TextInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final String CORRUPT_BUCKETING = "Hive table is corrupt. It is declared as being bucketed, but the files do not match the bucketing declaration.";
    public static final CompletableFuture<?> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final String connectorId;
    private final Table table;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final List<HiveBucketing.HiveBucket> buckets;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final DataSize maxSplitSize;
    private final int maxPartitionBatchSize;
    private final DataSize maxInitialSplitSize;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<HiveFileIterator> fileIterators = new ConcurrentLinkedDeque<HiveFileIterator>();
    private final AtomicInteger remainingInitialSplits;
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(String connectorId, Table table, Iterable<HivePartitionMetadata> partitions, Optional<HiveBucketHandle> bucketHandle, List<HiveBucketing.HiveBucket> buckets, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int maxPartitionBatchSize, int maxInitialSplits, boolean recursiveDirWalkerEnabled) {
        this.connectorId = connectorId;
        this.table = table;
        this.bucketHandle = bucketHandle;
        this.buckets = buckets;
        this.maxSplitSize = HiveSessionProperties.getMaxSplitSize(session);
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.maxInitialSplitSize = HiveSessionProperties.getMaxInitialSplitSize(session);
        this.remainingInitialSplits = new AtomicInteger(maxInitialSplits);
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
        this.hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.maxPartitionBatchSize; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeFinishedIfNecessary() {
        if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
            this.taskExecutionLock.writeLock().lock();
            try {
                if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                    this.hiveSplitSource.finished();
                }
            }
            finally {
                this.taskExecutionLock.writeLock().unlock();
            }
        }
    }

    private CompletableFuture<?> loadSplits() throws IOException {
        HiveFileIterator files = this.fileIterators.poll();
        if (files == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            this.loadPartition(partition);
            return COMPLETED_FUTURE;
        }
        while (files.hasNext() && !this.stopped) {
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            if (HadoopFileStatus.isDirectory(file)) {
                if (!this.recursiveDirWalkerEnabled) continue;
                HiveFileIterator fileIterator = new HiveFileIterator(file.getPath(), files.getFileSystem(), files.getDirectoryLister(), files.getNamenodeStats(), files.getPartitionName(), files.getInputFormat(), files.getSchema(), files.getPartitionKeys(), files.getEffectivePredicate(), files.getColumnCoercions());
                this.fileIterators.add(fileIterator);
                continue;
            }
            boolean splittable = HiveUtil.isSplittable(files.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
            CompletableFuture<?> future = this.hiveSplitSource.addToQueue(this.createHiveSplitIterator(files.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), files.getSchema(), files.getPartitionKeys(), splittable, this.session, OptionalInt.empty(), files.getEffectivePredicate(), files.getColumnCoercions(), BackgroundHiveSplitLoader.getPathDomain(files.getEffectivePredicate())));
            if (future.isDone()) continue;
            this.fileIterators.addFirst(files);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private void loadPartition(HivePartitionMetadata partition) throws IOException {
        String partitionName = partition.getHivePartition().getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain<HiveColumnHandle> effectivePredicate = partition.getHivePartition().getEffectivePredicate();
        Optional<Domain> pathDomain = BackgroundHiveSplitLoader.getPathDomain(effectivePredicate);
        Path path = new Path(BackgroundHiveSplitLoader.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.bucketHandle.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            for (Path targetPath : BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path)) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                Configuration targetConfiguration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, targetPath);
                JobConf targetJob = ConfigurationUtils.toJobConf(targetConfiguration);
                targetJob.setInputFormat(TextInputFormat.class);
                targetInputFormat.configure(targetJob);
                FileInputFormat.setInputPaths(targetJob, targetPath);
                InputSplit[] targetSplits = targetInputFormat.getSplits(targetJob, 0);
                if (!this.addSplitsToSource(targetSplits, partitionName, partitionKeys, schema, effectivePredicate, partition.getColumnCoercions(), pathDomain)) continue;
                return;
            }
            return;
        }
        if (BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
            FileInputFormat.setInputPaths(jobConf, path);
            InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
            this.addSplitsToSource(splits, partitionName, partitionKeys, schema, effectivePredicate, partition.getColumnCoercions(), pathDomain);
            return;
        }
        HiveFileIterator iterator = new HiveFileIterator(path, fs, this.directoryLister, this.namenodeStats, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions());
        if (!this.buckets.isEmpty()) {
            int bucketCount = this.buckets.get(0).getBucketCount();
            List<LocatedFileStatus> list = BackgroundHiveSplitLoader.listAndSortBucketFiles(iterator, bucketCount);
            ArrayList<Iterator<HiveSplit>> iteratorList = new ArrayList<Iterator<HiveSplit>>();
            for (HiveBucketing.HiveBucket bucket : this.buckets) {
                int bucketNumber = bucket.getBucketNumber();
                LocatedFileStatus file = list.get(bucketNumber);
                boolean splittable = HiveUtil.isSplittable(iterator.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
                iteratorList.add(this.createHiveSplitIterator(iterator.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), iterator.getSchema(), iterator.getPartitionKeys(), splittable, this.session, OptionalInt.of(bucketNumber), effectivePredicate, partition.getColumnCoercions(), pathDomain));
            }
            this.addToHiveSplitSourceRoundRobin(iteratorList);
            return;
        }
        if (this.bucketHandle.isPresent()) {
            int bucketCount = this.bucketHandle.get().getBucketCount();
            List<LocatedFileStatus> list = BackgroundHiveSplitLoader.listAndSortBucketFiles(iterator, bucketCount);
            ArrayList<Iterator<HiveSplit>> iteratorList = new ArrayList<Iterator<HiveSplit>>();
            for (int bucketIndex = 0; bucketIndex < bucketCount; ++bucketIndex) {
                LocatedFileStatus file = list.get(bucketIndex);
                boolean splittable = HiveUtil.isSplittable(iterator.getInputFormat(), this.hdfsEnvironment.getFileSystem(this.hdfsContext, file.getPath()), file.getPath());
                iteratorList.add(this.createHiveSplitIterator(iterator.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), file.getLen(), iterator.getSchema(), iterator.getPartitionKeys(), splittable, this.session, OptionalInt.of(bucketIndex), iterator.getEffectivePredicate(), partition.getColumnCoercions(), pathDomain));
            }
            this.addToHiveSplitSourceRoundRobin(iteratorList);
            return;
        }
        this.fileIterators.addLast(iterator);
    }

    private boolean addSplitsToSource(InputSplit[] targetSplits, String partitionName, List<HivePartitionKey> partitionKeys, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, Map<Integer, HiveType> columnCoercions, Optional<Domain> pathDomain) throws IOException {
        for (InputSplit inputSplit : targetSplits) {
            FileSplit split = (FileSplit)inputSplit;
            FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, split.getPath());
            FileStatus file = targetFilesystem.getFileStatus(split.getPath());
            this.hiveSplitSource.addToQueue(this.createHiveSplitIterator(partitionName, file.getPath().toString(), targetFilesystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), schema, partitionKeys, false, this.session, OptionalInt.empty(), effectivePredicate, columnCoercions, pathDomain));
            if (!this.stopped) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private void addToHiveSplitSourceRoundRobin(List<Iterator<HiveSplit>> iteratorList) {
        boolean done;
        do {
            done = true;
            for (Iterator<HiveSplit> hiveSplitIterator : iteratorList) {
                if (!hiveSplitIterator.hasNext()) continue;
                this.hiveSplitSource.addToQueue(hiveSplitIterator.next());
                done = false;
            }
        } while (!done);
    }

    private static List<LocatedFileStatus> listAndSortBucketFiles(HiveFileIterator hiveFileIterator, int bucketCount) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>(bucketCount);
        while (hiveFileIterator.hasNext()) {
            LocatedFileStatus next = (LocatedFileStatus)hiveFileIterator.next();
            if (HadoopFileStatus.isDirectory(next)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("%s Found sub-directory in bucket directory for partition: %s", CORRUPT_BUCKETING, hiveFileIterator.getPartitionName()));
            }
            list.add(next);
        }
        if (list.size() != bucketCount) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("%s The number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", CORRUPT_BUCKETING, list.size(), bucketCount, hiveFileIterator.getPartitionName()));
        }
        list.sort(null);
        return list;
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines(reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private Iterator<HiveSplit> createHiveSplitIterator(final String partitionName, final String path, BlockLocation[] blockLocations, long start, long length, final long fileSize, final Properties schema, final List<HivePartitionKey> partitionKeys, boolean splittable, ConnectorSession session, final OptionalInt bucketNumber, final TupleDomain<HiveColumnHandle> effectivePredicate, final Map<Integer, HiveType> columnCoercions, Optional<Domain> pathDomain) throws IOException {
        if (!BackgroundHiveSplitLoader.pathMatchesPredicate(pathDomain, path)) {
            return Collections.emptyIterator();
        }
        final boolean forceLocalScheduling = HiveSessionProperties.isForceLocalScheduling(session);
        if (splittable) {
            final PeekingIterator blockLocationIterator = Iterators.peekingIterator(Arrays.stream(blockLocations).iterator());
            return new AbstractIterator<HiveSplit>(){
                private long chunkOffset = 0L;

                @Override
                protected HiveSplit computeNext() {
                    long targetChunkSize;
                    List addresses;
                    if (!blockLocationIterator.hasNext()) {
                        return (HiveSplit)this.endOfData();
                    }
                    BlockLocation blockLocation = (BlockLocation)blockLocationIterator.peek();
                    try {
                        addresses = BackgroundHiveSplitLoader.toHostAddress(blockLocation.getHosts());
                    }
                    catch (IOException e) {
                        throw Throwables.propagate(e);
                    }
                    if (BackgroundHiveSplitLoader.this.remainingInitialSplits.decrementAndGet() >= 0) {
                        targetChunkSize = BackgroundHiveSplitLoader.this.maxInitialSplitSize.toBytes();
                    } else {
                        long maxBytes = BackgroundHiveSplitLoader.this.maxSplitSize.toBytes();
                        int chunks = Math.toIntExact((long)Math.ceil((double)(blockLocation.getLength() - this.chunkOffset) * 1.0 / (double)maxBytes));
                        targetChunkSize = (long)Math.ceil((double)(blockLocation.getLength() - this.chunkOffset) * 1.0 / (double)chunks);
                    }
                    long chunkLength = Math.min(targetChunkSize, blockLocation.getLength() - this.chunkOffset);
                    HiveSplit result = new HiveSplit(BackgroundHiveSplitLoader.this.connectorId, BackgroundHiveSplitLoader.this.table.getDatabaseName(), BackgroundHiveSplitLoader.this.table.getTableName(), partitionName, path, blockLocation.getOffset() + this.chunkOffset, chunkLength, fileSize, schema, partitionKeys, addresses, bucketNumber, forceLocalScheduling && BackgroundHiveSplitLoader.hasRealAddress(addresses), (TupleDomain<HiveColumnHandle>)effectivePredicate, columnCoercions);
                    this.chunkOffset += chunkLength;
                    if (this.chunkOffset >= blockLocation.getLength()) {
                        Preconditions.checkState(this.chunkOffset == blockLocation.getLength(), "Error splitting blocks");
                        blockLocationIterator.next();
                        this.chunkOffset = 0L;
                    }
                    return result;
                }
            };
        }
        ImmutableList<HostAddress> addresses = ImmutableList.of();
        if (blockLocations.length > 0) {
            addresses = BackgroundHiveSplitLoader.toHostAddress(blockLocations[0].getHosts());
        }
        return Iterators.singletonIterator(new HiveSplit(this.connectorId, this.table.getDatabaseName(), this.table.getTableName(), partitionName, path, start, length, fileSize, schema, partitionKeys, addresses, bucketNumber, forceLocalScheduling && BackgroundHiveSplitLoader.hasRealAddress(addresses), effectivePredicate, columnCoercions));
    }

    private static boolean hasRealAddress(List<HostAddress> addresses) {
        return addresses.stream().anyMatch(address -> !address.getHostText().equals("localhost"));
    }

    private static List<HostAddress> toHostAddress(String[] hosts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String host : hosts) {
            builder.add(HostAddress.fromString((String)host));
        }
        return builder.build();
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add(new HivePartitionKey(name, hiveType, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    private static String getPartitionLocation(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return table.getStorage().getLocation();
        }
        return partition.get().getStorage().getLocation();
    }

    private static Optional<Domain> getPathDomain(TupleDomain<HiveColumnHandle> effectivePredicate) {
        if (!effectivePredicate.getDomains().isPresent()) {
            return Optional.empty();
        }
        return ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> HiveColumnHandle.isPathColumnHandle((HiveColumnHandle)entry.getKey())).findFirst().map(Map.Entry::getValue);
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        if (!pathDomain.isPresent()) {
            return true;
        }
        return pathDomain.get().includesNullableValue((Object)Slices.utf8Slice(path));
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        @Override
        public ResumableTask.TaskStatus process() {
            while (!BackgroundHiveSplitLoader.this.stopped) {
                try {
                    CompletableFuture future;
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                    try {
                        future = BackgroundHiveSplitLoader.this.loadSplits();
                    }
                    finally {
                        BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                    }
                    BackgroundHiveSplitLoader.this.invokeFinishedIfNecessary();
                    if (future.isDone()) continue;
                    return ResumableTask.TaskStatus.continueOn(future);
                }
                catch (Exception e) {
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e);
                    continue;
                }
                break;
            }
            return ResumableTask.TaskStatus.finished();
        }
    }
}

