/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.HeadBucketRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.HeadBucketResult;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.waiters.HeadBucketFunction;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.waiters.HeadObjectFunction;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.HttpFailureStatusAcceptor;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.PollingStrategy;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.Waiter;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.WaiterBuilder;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.waiters.WaiterState;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

