/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry;

import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.v2.RetryPolicy;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.v2.RetryPolicyContext;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public class RetryPolicyAdapter
implements RetryPolicy {
    private final org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.RetryPolicy legacyRetryPolicy;
    private final ClientConfiguration clientConfiguration;

    public RetryPolicyAdapter(org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.RetryPolicy legacyRetryPolicy, ClientConfiguration clientConfiguration) {
        this.legacyRetryPolicy = ValidationUtils.assertNotNull(legacyRetryPolicy, "legacyRetryPolicy");
        this.clientConfiguration = ValidationUtils.assertNotNull(clientConfiguration, "clientConfiguration");
    }

    @Override
    public long computeDelayBeforeNextRetry(RetryPolicyContext context) {
        return this.legacyRetryPolicy.getBackoffStrategy().delayBeforeNextRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext context) {
        if (context.retriesAttempted() >= this.getMaxErrorRetry()) {
            return false;
        }
        return this.legacyRetryPolicy.getRetryCondition().shouldRetry((AmazonWebServiceRequest)context.originalRequest(), (AmazonClientException)context.exception(), context.retriesAttempted());
    }

    public org.apache.flink.fs.s3presto.shaded.com.amazonaws.retry.RetryPolicy getLegacyRetryPolicy() {
        return this.legacyRetryPolicy;
    }

    private int getMaxErrorRetry() {
        if (this.legacyRetryPolicy.isMaxErrorRetryInClientConfigHonored() && this.clientConfiguration.getMaxErrorRetry() >= 0) {
            return this.clientConfiguration.getMaxErrorRetry();
        }
        return this.legacyRetryPolicy.getMaxErrorRetry();
    }
}

