/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib;

import java.io.IOException;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.PathFilter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.RecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Reporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Job;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CombineFileInputFormat<K, V>
extends org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat<K, V>
implements InputFormat<K, V> {
    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        List<org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit> newStyleSplits = super.getSplits(Job.getInstance(job));
        InputSplit[] ret = new InputSplit[newStyleSplits.size()];
        for (int pos = 0; pos < newStyleSplits.size(); ++pos) {
            org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.CombineFileSplit newStyleSplit = (org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input.CombineFileSplit)newStyleSplits.get(pos);
            ret[pos] = new CombineFileSplit(job, newStyleSplit.getPaths(), newStyleSplit.getStartOffsets(), newStyleSplit.getLengths(), newStyleSplit.getLocations());
        }
        return ret;
    }

    @Deprecated
    protected void createPool(JobConf conf, List<PathFilter> filters) {
        this.createPool(filters);
    }

    @Deprecated
    protected void createPool(JobConf conf, PathFilter ... filters) {
        this.createPool(filters);
    }

    @Override
    public abstract RecordReader<K, V> getRecordReader(InputSplit var1, JobConf var2, Reporter var3) throws IOException;

    @Override
    public org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.RecordReader<K, V> createRecordReader(org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit split, TaskAttemptContext context) throws IOException {
        return null;
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        List<FileStatus> result = super.listStatus(Job.getInstance(job));
        return result.toArray(new FileStatus[result.size()]);
    }

    @Override
    @InterfaceAudience.Private
    protected boolean isSplitable(JobContext context, Path file) {
        try {
            return this.isSplitable(FileSystem.get(context.getConfiguration()), file);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    protected boolean isSplitable(FileSystem fs, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(fs.getConf()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }
}

