/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util.Canceler;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;

public class DataTransferThrottler {
    private final long period;
    private final long periodExtension;
    private long bytesPerPeriod;
    private long curPeriodStart = Time.monotonicNow();
    private long curReserve;
    private long bytesAlreadyUsed;

    public DataTransferThrottler(long bandwidthPerSec) {
        this(500L, bandwidthPerSec);
    }

    public DataTransferThrottler(long period, long bandwidthPerSec) {
        this.period = period;
        this.curReserve = this.bytesPerPeriod = bandwidthPerSec * period / 1000L;
        this.periodExtension = period * 3L;
    }

    public synchronized long getBandwidth() {
        return this.bytesPerPeriod * 1000L / this.period;
    }

    public synchronized void setBandwidth(long bytesPerSecond) {
        if (bytesPerSecond <= 0L) {
            throw new IllegalArgumentException("" + bytesPerSecond);
        }
        this.bytesPerPeriod = bytesPerSecond * this.period / 1000L;
    }

    public synchronized void throttle(long numOfBytes) {
        this.throttle(numOfBytes, null);
    }

    public synchronized void throttle(long numOfBytes, Canceler canceler) {
        if (numOfBytes <= 0L) {
            return;
        }
        this.curReserve -= numOfBytes;
        this.bytesAlreadyUsed += numOfBytes;
        while (this.curReserve <= 0L) {
            long curPeriodEnd;
            if (canceler != null && canceler.isCancelled()) {
                return;
            }
            long now = Time.monotonicNow();
            if (now < (curPeriodEnd = this.curPeriodStart + this.period)) {
                try {
                    this.wait(curPeriodEnd - now);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (now < this.curPeriodStart + this.periodExtension) {
                this.curPeriodStart = curPeriodEnd;
                this.curReserve += this.bytesPerPeriod;
                continue;
            }
            this.curPeriodStart = now;
            this.curReserve = this.bytesPerPeriod - this.bytesAlreadyUsed;
        }
        this.bytesAlreadyUsed -= numOfBytes;
    }
}

