/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.web.webhdfs;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.web.webhdfs.ParameterParser;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.token.Token;

class DataNodeUGIProvider {
    private final ParameterParser params;

    DataNodeUGIProvider(ParameterParser params) {
        this.params = params;
    }

    UserGroupInformation ugi() throws IOException {
        if (UserGroupInformation.isSecurityEnabled()) {
            return this.tokenUGI();
        }
        String usernameFromQuery = this.params.userName();
        String doAsUserFromQuery = this.params.doAsUser();
        String remoteUser = usernameFromQuery == null ? JspHelper.getDefaultWebUserName(this.params.conf()) : usernameFromQuery;
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser(remoteUser);
        JspHelper.checkUsername(ugi.getShortUserName(), usernameFromQuery);
        if (doAsUserFromQuery != null) {
            ugi = UserGroupInformation.createProxyUser(doAsUserFromQuery, ugi);
        }
        return ugi;
    }

    private UserGroupInformation tokenUGI() throws IOException {
        Token<DelegationTokenIdentifier> token = this.params.delegationToken();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        id.readFields(in);
        UserGroupInformation ugi = id.getUser();
        ugi.addToken(token);
        return ugi;
    }
}

