/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class FsUrlConnection
extends URLConnection {
    private Configuration conf;
    private InputStream is;

    FsUrlConnection(Configuration conf, URL url) {
        super(url);
        this.conf = conf;
    }

    @Override
    public void connect() throws IOException {
        try {
            FileSystem fs = FileSystem.get(this.url.toURI(), this.conf);
            this.is = fs.open(new Path(this.url.getPath()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
        }
        return this.is;
    }
}

