/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.SchemaTableName;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String clientId;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveTableHandle other = (HiveTableHandle)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.clientId + ":" + this.schemaName + ":" + this.tableName;
    }
}

