/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.BasicSessionCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.CredentialsEndpointProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.EC2CredentialsUtils;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.DateUtils;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.json.Jackson;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.org.apache.commons.logging.LogFactory;

@SdkInternalApi
class EC2CredentialsFetcher {
    private static final Log LOG = LogFactory.getLog(EC2CredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private volatile AWSCredentials credentials;
    private volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;
    private final CredentialsEndpointProvider credentailsEndpointProvider;

    public EC2CredentialsFetcher(CredentialsEndpointProvider credentailsEndpointProvider) {
        this.credentailsEndpointProvider = credentailsEndpointProvider;
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new SdkClientException("The credentials received have been expired");
        }
        return this.credentials;
    }

    protected boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = EC2CredentialsUtils.getInstance().readResource(this.credentailsEndpointProvider.getCredentialsEndpoint(), this.credentailsEndpointProvider.getRetryPolicy());
            JsonNode node = Jackson.jsonNodeOf(credentialsResponse);
            JsonNode accessKey = node.get(ACCESS_KEY_ID);
            JsonNode secretKey = node.get(SECRET_ACCESS_KEY);
            JsonNode token = node.get(TOKEN);
            if (null == accessKey || null == secretKey) {
                throw new SdkClientException("Unable to load credentials.");
            }
            this.credentials = null != token ? new BasicSessionCredentials(accessKey.asText(), secretKey.asText(), token.asText()) : new BasicAWSCredentials(accessKey.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node.get("Expiration");
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                expiration = expiration.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception ex) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 instance", ex);
                }
            }
        }
        catch (JsonMappingException e) {
            this.handleError("Unable to parse response returned from service endpoint", e);
        }
        catch (IOException e) {
            this.handleError("Unable to load credentials from service endpoint", e);
        }
        catch (URISyntaxException e) {
            this.handleError("Unable to load credentials from service endpoint", e);
        }
    }

    private void handleError(String errorMessage, Exception e) {
        if (this.credentials == null || this.expired()) {
            throw new SdkClientException(errorMessage, e);
        }
        LOG.debug(errorMessage, e);
    }

    public void refresh() {
        this.credentials = null;
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    public Date getCredentialsExpiration() {
        return this.credentialsExpiration;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

