/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.compiler.CodeGenerator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.compiler.JFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.record.compiler.JRecord;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

class CppGenerator
extends CodeGenerator {
    CppGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        try (FileWriter cc = new FileWriter(name + ".cc");
             FileWriter hh = new FileWriter(name + ".hh");){
            String fileName = new File(name).getName();
            hh.write("#ifndef __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            hh.write("#define __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            hh.write("#include \"recordio.hh\"\n");
            hh.write("#include \"recordTypeInfo.hh\"\n");
            Iterator<Object> iter = ilist.iterator();
            while (iter.hasNext()) {
                hh.write("#include \"" + iter.next().getName() + ".hh\"\n");
            }
            cc.write("#include \"" + fileName + ".hh\"\n");
            cc.write("#include \"utils.hh\"\n");
            iter = rlist.iterator();
            while (iter.hasNext()) {
                ((JRecord)iter.next()).genCppCode(hh, cc, options);
            }
            hh.write("#endif //" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
        }
    }
}

