/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.LongWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.InputSplit;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConfigurable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.RecordReader;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Reporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.db.DBConfiguration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.db.DBWritable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.Job;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBInputFormat;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DBInputFormat<T extends DBWritable>
extends org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBInputFormat<T>
implements InputFormat<LongWritable, T>,
JobConfigurable {
    @Override
    public void configure(JobConf job) {
        super.setConf(job);
    }

    @Override
    public RecordReader<LongWritable, T> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new DBRecordReaderWrapper((org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBRecordReader)this.createDBRecordReader((DBInputFormat.DBInputSplit)((Object)split), job));
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int chunks) throws IOException {
        List<org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit> newSplits = super.getSplits(Job.getInstance(job));
        InputSplit[] ret = new InputSplit[newSplits.size()];
        int i = 0;
        for (org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit s : newSplits) {
            DBInputFormat.DBInputSplit split = (DBInputFormat.DBInputSplit)s;
            ret[i++] = new DBInputSplit(split.getStart(), split.getEnd());
        }
        return ret;
    }

    public static void setInput(JobConf job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String orderBy, String ... fieldNames) {
        job.setInputFormat(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job);
        dbConf.setInputClass(inputClass);
        dbConf.setInputTableName(tableName);
        dbConf.setInputFieldNames(fieldNames);
        dbConf.setInputConditions(conditions);
        dbConf.setInputOrderBy(orderBy);
    }

    public static void setInput(JobConf job, Class<? extends DBWritable> inputClass, String inputQuery, String inputCountQuery) {
        job.setInputFormat(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job);
        dbConf.setInputClass(inputClass);
        dbConf.setInputQuery(inputQuery);
        dbConf.setInputCountQuery(inputCountQuery);
    }

    protected static class DBInputSplit
    extends DBInputFormat.DBInputSplit
    implements InputSplit {
        public DBInputSplit() {
        }

        public DBInputSplit(long start, long end) {
            super(start, end);
        }
    }

    public static class NullDBWritable
    extends DBInputFormat.NullDBWritable
    implements DBWritable,
    Writable {
    }

    private static class DBRecordReaderWrapper<T extends DBWritable>
    implements RecordReader<LongWritable, T> {
        private org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBRecordReader<T> rr;

        public DBRecordReaderWrapper(org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBRecordReader<T> inner) {
            this.rr = inner;
        }

        @Override
        public void close() throws IOException {
            this.rr.close();
        }

        @Override
        public LongWritable createKey() {
            return new LongWritable();
        }

        @Override
        public T createValue() {
            return (T)((DBWritable)this.rr.createValue());
        }

        @Override
        public float getProgress() throws IOException {
            return this.rr.getProgress();
        }

        @Override
        public long getPos() throws IOException {
            return this.rr.getPos();
        }

        @Override
        public boolean next(LongWritable key, T value) throws IOException {
            return this.rr.next(key, value);
        }
    }

    protected class DBRecordReader
    extends org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.db.DBRecordReader<T>
    implements RecordReader<LongWritable, T> {
        protected DBRecordReader(DBInputSplit split, Class<T> inputClass, JobConf job) throws SQLException {
            super(split, inputClass, job, DBInputFormat.this.connection, DBInputFormat.this.dbConf, DBInputFormat.this.conditions, DBInputFormat.this.fieldNames, DBInputFormat.this.tableName);
        }

        protected DBRecordReader(DBInputSplit split, Class<T> inputClass, JobConf job, Connection conn, DBConfiguration dbConfig, String cond, String[] fields, String table) throws SQLException {
            super(split, inputClass, job, conn, dbConfig, cond, fields, table);
        }

        @Override
        public LongWritable createKey() {
            return new LongWritable();
        }

        @Override
        public T createValue() {
            return (DBWritable)super.createValue();
        }

        @Override
        public long getPos() throws IOException {
            return super.getPos();
        }

        @Override
        public boolean next(LongWritable key, T value) throws IOException {
            return super.next(key, value);
        }
    }
}

