/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableComparable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.OutputCollector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.Reporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueAggregator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorBaseDescriptor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.lib.aggregate.ValueAggregatorJobBase;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorCombiner<K1 extends WritableComparable, V1 extends Writable>
extends ValueAggregatorJobBase<K1, V1> {
    @Override
    public void configure(JobConf job) {
    }

    @Override
    public void reduce(Text key, Iterator<Text> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        String keyStr = key.toString();
        int pos = keyStr.indexOf(":");
        String type = keyStr.substring(0, pos);
        ValueAggregator aggregator = ValueAggregatorBaseDescriptor.generateValueAggregator(type);
        while (values.hasNext()) {
            aggregator.addNextValue(values.next());
        }
        for (Object v : aggregator.getCombinerOutput()) {
            if (v instanceof Text) {
                output.collect(key, (Text)v);
                continue;
            }
            output.collect(key, new Text(v.toString()));
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void map(K1 arg0, V1 arg1, OutputCollector<Text, Text> arg2, Reporter arg3) throws IOException {
        throw new IOException("should not be called\n");
    }
}

