/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util.EnumCounters;

public class QuotaCounts {
    private EnumCounters<Quota> nsSsCounts;
    private EnumCounters<StorageType> tsCounts;

    private QuotaCounts(Builder builder) {
        this.nsSsCounts = builder.nsSsCounts;
        this.tsCounts = builder.tsCounts;
    }

    public void add(QuotaCounts that) {
        this.nsSsCounts.add(that.nsSsCounts);
        this.tsCounts.add(that.tsCounts);
    }

    public void subtract(QuotaCounts that) {
        this.nsSsCounts.subtract(that.nsSsCounts);
        this.tsCounts.subtract(that.tsCounts);
    }

    public QuotaCounts negation() {
        QuotaCounts ret = new Builder().quotaCount(this).build();
        ret.nsSsCounts.negation();
        ret.tsCounts.negation();
        return ret;
    }

    public long getNameSpace() {
        return this.nsSsCounts.get(Quota.NAMESPACE);
    }

    public void setNameSpace(long nameSpaceCount) {
        this.nsSsCounts.set(Quota.NAMESPACE, nameSpaceCount);
    }

    public void addNameSpace(long nsDelta) {
        this.nsSsCounts.add(Quota.NAMESPACE, nsDelta);
    }

    public long getStorageSpace() {
        return this.nsSsCounts.get(Quota.STORAGESPACE);
    }

    public void setStorageSpace(long spaceCount) {
        this.nsSsCounts.set(Quota.STORAGESPACE, spaceCount);
    }

    public void addStorageSpace(long dsDelta) {
        this.nsSsCounts.add(Quota.STORAGESPACE, dsDelta);
    }

    public EnumCounters<StorageType> getTypeSpaces() {
        EnumCounters<StorageType> ret = new EnumCounters<StorageType>(StorageType.class);
        ret.set(this.tsCounts);
        return ret;
    }

    void setTypeSpaces(EnumCounters<StorageType> that) {
        if (that != null) {
            this.tsCounts.set(that);
        }
    }

    long getTypeSpace(StorageType type) {
        return this.tsCounts.get(type);
    }

    void setTypeSpace(StorageType type, long spaceCount) {
        this.tsCounts.set(type, spaceCount);
    }

    public void addTypeSpace(StorageType type, long delta) {
        this.tsCounts.add(type, delta);
    }

    public boolean anyNsSsCountGreaterOrEqual(long val) {
        return this.nsSsCounts.anyGreaterOrEqual(val);
    }

    public boolean anyTypeSpaceCountGreaterOrEqual(long val) {
        return this.tsCounts.anyGreaterOrEqual(val);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof QuotaCounts)) {
            return false;
        }
        QuotaCounts that = (QuotaCounts)obj;
        return this.nsSsCounts.equals(that.nsSsCounts) && this.tsCounts.equals(that.tsCounts);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public static class Builder {
        private EnumCounters<Quota> nsSsCounts = new EnumCounters<Quota>(Quota.class);
        private EnumCounters<StorageType> tsCounts = new EnumCounters<StorageType>(StorageType.class);

        public Builder nameSpace(long val) {
            this.nsSsCounts.set(Quota.NAMESPACE, val);
            return this;
        }

        public Builder storageSpace(long val) {
            this.nsSsCounts.set(Quota.STORAGESPACE, val);
            return this;
        }

        public Builder typeSpaces(EnumCounters<StorageType> val) {
            if (val != null) {
                this.tsCounts.set(val);
            }
            return this;
        }

        public Builder typeSpaces(long val) {
            this.tsCounts.reset(val);
            return this;
        }

        public Builder quotaCount(QuotaCounts that) {
            this.nsSsCounts.set(that.nsSsCounts);
            this.tsCounts.set(that.tsCounts);
            return this;
        }

        public QuotaCounts build() {
            return new QuotaCounts(this);
        }
    }
}

